; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-linux-gnu -mattr=+sve2p1 < %s | FileCheck %s
; RUN: llc -mtriple=aarch64-linux-gnu -mattr=+sme2 < %s | FileCheck %s

define i64 @test_svcntp_c8_vlx2(target("aarch64.svcount") %pn) nounwind {
; CHECK-LABEL: test_svcntp_c8_vlx2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cntp x0, pn0.b, vlx2
; CHECK-NEXT:    ret
  %res = call i64 @llvm.aarch64.sve.cntp.c8(target("aarch64.svcount") %pn, i32 2)
  ret i64 %res
}

define i64 @test_svcntp_c8_vlx4(target("aarch64.svcount") %pn) nounwind {
; CHECK-LABEL: test_svcntp_c8_vlx4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cntp x0, pn0.b, vlx4
; CHECK-NEXT:    ret
  %res = call i64 @llvm.aarch64.sve.cntp.c8(target("aarch64.svcount") %pn, i32 4)
  ret i64 %res
}

define i64 @test_svcntp_c16_vlx2(target("aarch64.svcount") %pn) nounwind {
; CHECK-LABEL: test_svcntp_c16_vlx2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cntp x0, pn0.h, vlx2
; CHECK-NEXT:    ret
  %res = call i64 @llvm.aarch64.sve.cntp.c16(target("aarch64.svcount") %pn, i32 2)
  ret i64 %res
}

define i64 @test_svcntp_c16_vlx4(target("aarch64.svcount") %pn) nounwind {
; CHECK-LABEL: test_svcntp_c16_vlx4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cntp x0, pn0.h, vlx4
; CHECK-NEXT:    ret
  %res = call i64 @llvm.aarch64.sve.cntp.c16(target("aarch64.svcount") %pn, i32 4)
  ret i64 %res
}

define i64 @test_svcntp_c32_vlx2(target("aarch64.svcount") %pn) nounwind {
; CHECK-LABEL: test_svcntp_c32_vlx2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cntp x0, pn0.s, vlx2
; CHECK-NEXT:    ret
  %res = call i64 @llvm.aarch64.sve.cntp.c32(target("aarch64.svcount") %pn, i32 2)
  ret i64 %res
}

define i64 @test_svcntp_c32_vlx4(target("aarch64.svcount") %pn) nounwind {
; CHECK-LABEL: test_svcntp_c32_vlx4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cntp x0, pn0.s, vlx4
; CHECK-NEXT:    ret
  %res = call i64 @llvm.aarch64.sve.cntp.c32(target("aarch64.svcount") %pn, i32 4)
  ret i64 %res
}

define i64 @test_svcntp_c64_vlx2(target("aarch64.svcount") %pn) nounwind {
; CHECK-LABEL: test_svcntp_c64_vlx2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cntp x0, pn0.d, vlx2
; CHECK-NEXT:    ret
  %res = call i64 @llvm.aarch64.sve.cntp.c64(target("aarch64.svcount") %pn, i32 2)
  ret i64 %res
}

define i64 @test_svcntp_c64_vlx4(target("aarch64.svcount") %pn) nounwind {
; CHECK-LABEL: test_svcntp_c64_vlx4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cntp x0, pn0.d, vlx4
; CHECK-NEXT:    ret
  %res = call i64 @llvm.aarch64.sve.cntp.c64(target("aarch64.svcount") %pn, i32 4)
  ret i64 %res
}


declare i64 @llvm.aarch64.sve.cntp.c8(target("aarch64.svcount"), i32)
declare i64 @llvm.aarch64.sve.cntp.c16(target("aarch64.svcount"), i32)
declare i64 @llvm.aarch64.sve.cntp.c32(target("aarch64.svcount"), i32)
declare i64 @llvm.aarch64.sve.cntp.c64(target("aarch64.svcount"), i32)
