; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 2
; RUN: opt < %s -mtriple=riscv64 -mattr=+v,+f,+d -disable-output -passes="print<cost-model>" 2>&1 | FileCheck %s

define <2 x i8> @phi_v2i8_small(i1 %c) {
; CHECK-LABEL: 'phi_v2i8_small'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br i1 %c, label %a, label %b
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %x = phi <2 x i8> [ <i8 1, i8 -1>, %a ], [ <i8 -1, i8 1>, %b ]
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <2 x i8> %x
;
  br i1 %c, label %a, label %b
a:
  br label %d
b:
  br label %d
d:
  %x = phi <2 x i8> [<i8 1, i8 -1>, %a], [<i8 -1, i8 1>, %b]
  ret <2 x i8> %x
}

define <4 x i8> @phi_v4i8_splat(i1 %c) {
; CHECK-LABEL: 'phi_v4i8_splat'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br i1 %c, label %a, label %b
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %x = phi <4 x i8> [ <i8 1, i8 1, i8 1, i8 1>, %a ], [ <i8 2, i8 2, i8 2, i8 2>, %b ]
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i8> %x
;
  br i1 %c, label %a, label %b
a:
  br label %d
b:
  br label %d
d:
  %x = phi <4 x i8> [<i8 1, i8 1, i8 1, i8 1>, %a], [<i8 2, i8 2, i8 2, i8 2>, %b]
  ret <4 x i8> %x
}

define <4 x i8> @phi_v4i8_small(i1 %c) {
; CHECK-LABEL: 'phi_v4i8_small'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br i1 %c, label %a, label %b
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %x = phi <4 x i8> [ <i8 1, i8 2, i8 3, i8 4>, %a ], [ <i8 2, i8 4, i8 6, i8 8>, %b ]
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i8> %x
;
  br i1 %c, label %a, label %b
a:
  br label %d
b:
  br label %d
d:
  %x = phi <4 x i8> [<i8 1, i8 2, i8 3, i8 4>, %a], [<i8 2, i8 4, i8 6, i8 8>, %b]
  ret <4 x i8> %x
}

define <4 x i8> @phi_v4i8_large(i1 %c) {
; CHECK-LABEL: 'phi_v4i8_large'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br i1 %c, label %a, label %b
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %x = phi <4 x i8> [ <i8 -46, i8 -31, i8 15, i8 74>, %a ], [ <i8 8, i8 32, i8 -59, i8 12>, %b ]
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i8> %x
;
  br i1 %c, label %a, label %b
a:
  br label %d
b:
  br label %d
d:
  %x = phi <4 x i8> [<i8 1234, i8 4321, i8 9999, i8 2378>, %a], [<i8 7432, i8 -4832, i8 381381, i8 12>, %b]
  ret <4 x i8> %x
}

; The cost should be conservative and assume it will need to materialize the more expensive constant
define <4 x i8> @phi_v4i8_cheap_and_expensive(i1 %c) {
; CHECK-LABEL: 'phi_v4i8_cheap_and_expensive'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br i1 %c, label %a, label %b
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %x = phi <4 x i8> [ <i8 1, i8 1, i8 1, i8 1>, %a ], [ <i8 8, i8 32, i8 -59, i8 12>, %b ]
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i8> %x
;
  br i1 %c, label %a, label %b
a:
  br label %d
b:
  br label %d
d:
  %x = phi <4 x i8> [<i8 1, i8 1, i8 1, i8 1>, %a], [<i8 7432, i8 -4832, i8 381381, i8 12>, %b]
  ret <4 x i8> %x
}

define <4 x i16> @phi_v4i16_splat(i1 %c) {
; CHECK-LABEL: 'phi_v4i16_splat'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br i1 %c, label %a, label %b
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %x = phi <4 x i16> [ <i16 1, i16 1, i16 1, i16 1>, %a ], [ <i16 2, i16 2, i16 2, i16 2>, %b ]
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i16> %x
;
  br i1 %c, label %a, label %b
a:
  br label %d
b:
  br label %d
d:
  %x = phi <4 x i16> [<i16 1, i16 1, i16 1, i16 1>, %a], [<i16 2, i16 2, i16 2, i16 2>, %b]
  ret <4 x i16> %x
}

define <4 x i16> @phi_v4i16_small(i1 %c) {
; CHECK-LABEL: 'phi_v4i16_small'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br i1 %c, label %a, label %b
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %x = phi <4 x i16> [ <i16 1, i16 2, i16 3, i16 4>, %a ], [ <i16 2, i16 4, i16 6, i16 8>, %b ]
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i16> %x
;
  br i1 %c, label %a, label %b
a:
  br label %d
b:
  br label %d
d:
  %x = phi <4 x i16> [<i16 1, i16 2, i16 3, i16 4>, %a], [<i16 2, i16 4, i16 6, i16 8>, %b]
  ret <4 x i16> %x
}

define <4 x i16> @phi_v4i16_large(i1 %c) {
; CHECK-LABEL: 'phi_v4i16_large'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br i1 %c, label %a, label %b
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %x = phi <4 x i16> [ <i16 1234, i16 4321, i16 9999, i16 2378>, %a ], [ <i16 7432, i16 -4832, i16 -11835, i16 12>, %b ]
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i16> %x
;
  br i1 %c, label %a, label %b
a:
  br label %d
b:
  br label %d
d:
  %x = phi <4 x i16> [<i16 1234, i16 4321, i16 9999, i16 2378>, %a], [<i16 7432, i16 -4832, i16 381381, i16 12>, %b]
  ret <4 x i16> %x
}

; The cost should be conservative and assume it will need to materialize the more expensive constant
define <4 x i16> @phi_v4i16_cheap_and_expensive(i1 %c) {
; CHECK-LABEL: 'phi_v4i16_cheap_and_expensive'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br i1 %c, label %a, label %b
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %x = phi <4 x i16> [ <i16 1, i16 1, i16 1, i16 1>, %a ], [ <i16 7432, i16 -4832, i16 -11835, i16 12>, %b ]
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i16> %x
;
  br i1 %c, label %a, label %b
a:
  br label %d
b:
  br label %d
d:
  %x = phi <4 x i16> [<i16 1, i16 1, i16 1, i16 1>, %a], [<i16 7432, i16 -4832, i16 381381, i16 12>, %b]
  ret <4 x i16> %x
}

define <4 x i32> @phi_v4i32_splat(i1 %c) {
; CHECK-LABEL: 'phi_v4i32_splat'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br i1 %c, label %a, label %b
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %x = phi <4 x i32> [ <i32 1, i32 1, i32 1, i32 1>, %a ], [ <i32 2, i32 2, i32 2, i32 2>, %b ]
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i32> %x
;
  br i1 %c, label %a, label %b
a:
  br label %d
b:
  br label %d
d:
  %x = phi <4 x i32> [<i32 1, i32 1, i32 1, i32 1>, %a], [<i32 2, i32 2, i32 2, i32 2>, %b]
  ret <4 x i32> %x
}

define <4 x i32> @phi_v4i32_small(i1 %c) {
; CHECK-LABEL: 'phi_v4i32_small'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br i1 %c, label %a, label %b
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %x = phi <4 x i32> [ <i32 1, i32 2, i32 3, i32 4>, %a ], [ <i32 2, i32 4, i32 6, i32 8>, %b ]
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i32> %x
;
  br i1 %c, label %a, label %b
a:
  br label %d
b:
  br label %d
d:
  %x = phi <4 x i32> [<i32 1, i32 2, i32 3, i32 4>, %a], [<i32 2, i32 4, i32 6, i32 8>, %b]
  ret <4 x i32> %x
}

define <4 x i32> @phi_v4i32_large(i1 %c) {
; CHECK-LABEL: 'phi_v4i32_large'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br i1 %c, label %a, label %b
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %x = phi <4 x i32> [ <i32 1234, i32 4321, i32 9999, i32 2378>, %a ], [ <i32 7432, i32 -4832, i32 381381, i32 12>, %b ]
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i32> %x
;
  br i1 %c, label %a, label %b
a:
  br label %d
b:
  br label %d
d:
  %x = phi <4 x i32> [<i32 1234, i32 4321, i32 9999, i32 2378>, %a], [<i32 7432, i32 -4832, i32 381381, i32 12>, %b]
  ret <4 x i32> %x
}

; The cost should be conservative and assume it will need to materialize the more expensive constant
define <4 x i32> @phi_v4i32_cheap_and_expensive(i1 %c) {
; CHECK-LABEL: 'phi_v4i32_cheap_and_expensive'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br i1 %c, label %a, label %b
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %x = phi <4 x i32> [ <i32 1, i32 1, i32 1, i32 1>, %a ], [ <i32 7432, i32 -4832, i32 381381, i32 12>, %b ]
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i32> %x
;
  br i1 %c, label %a, label %b
a:
  br label %d
b:
  br label %d
d:
  %x = phi <4 x i32> [<i32 1, i32 1, i32 1, i32 1>, %a], [<i32 7432, i32 -4832, i32 381381, i32 12>, %b]
  ret <4 x i32> %x
}

define <4 x i64> @phi_v4i64_splat(i1 %c) {
; CHECK-LABEL: 'phi_v4i64_splat'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br i1 %c, label %a, label %b
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %x = phi <4 x i64> [ <i64 1, i64 1, i64 1, i64 1>, %a ], [ <i64 2, i64 2, i64 2, i64 2>, %b ]
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i64> %x
;
  br i1 %c, label %a, label %b
a:
  br label %d
b:
  br label %d
d:
  %x = phi <4 x i64> [<i64 1, i64 1, i64 1, i64 1>, %a], [<i64 2, i64 2, i64 2, i64 2>, %b]
  ret <4 x i64> %x
}

define <4 x i64> @phi_v4i64_small(i1 %c) {
; CHECK-LABEL: 'phi_v4i64_small'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br i1 %c, label %a, label %b
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %x = phi <4 x i64> [ <i64 1, i64 2, i64 3, i64 4>, %a ], [ <i64 2, i64 4, i64 6, i64 8>, %b ]
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i64> %x
;
  br i1 %c, label %a, label %b
a:
  br label %d
b:
  br label %d
d:
  %x = phi <4 x i64> [<i64 1, i64 2, i64 3, i64 4>, %a], [<i64 2, i64 4, i64 6, i64 8>, %b]
  ret <4 x i64> %x
}

define <4 x i64> @phi_v4i64_large(i1 %c) {
; CHECK-LABEL: 'phi_v4i64_large'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br i1 %c, label %a, label %b
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %x = phi <4 x i64> [ <i64 1234, i64 4321, i64 9999, i64 2378>, %a ], [ <i64 7432, i64 -4832, i64 381381, i64 12>, %b ]
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i64> %x
;
  br i1 %c, label %a, label %b
a:
  br label %d
b:
  br label %d
d:
  %x = phi <4 x i64> [<i64 1234, i64 4321, i64 9999, i64 2378>, %a], [<i64 7432, i64 -4832, i64 381381, i64 12>, %b]
  ret <4 x i64> %x
}

; The cost should be conservative and assume it will need to materialize the more expensive constant
define <4 x i64> @phi_v4i64_cheap_and_expensive(i1 %c) {
; CHECK-LABEL: 'phi_v4i64_cheap_and_expensive'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br i1 %c, label %a, label %b
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %x = phi <4 x i64> [ <i64 1, i64 1, i64 1, i64 1>, %a ], [ <i64 7432, i64 -4832, i64 381381, i64 12>, %b ]
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i64> %x
;
  br i1 %c, label %a, label %b
a:
  br label %d
b:
  br label %d
d:
  %x = phi <4 x i64> [<i64 1, i64 1, i64 1, i64 1>, %a], [<i64 7432, i64 -4832, i64 381381, i64 12>, %b]
  ret <4 x i64> %x
}

define <4 x half> @phi_v4f16_splat(i1 %c) {
; CHECK-LABEL: 'phi_v4f16_splat'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br i1 %c, label %a, label %b
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %x = phi <4 x half> [ <half 0xH3C00, half 0xH3C00, half 0xH3C00, half 0xH3C00>, %a ], [ <half 0xH4000, half 0xH4000, half 0xH4000, half 0xH4D00>, %b ]
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x half> %x
;
  br i1 %c, label %a, label %b
a:
  br label %d
b:
  br label %d
d:
  %x = phi <4 x half> [<half 1.0, half 1.0, half 1.0, half 1.0>, %a], [<half 2.0, half 2.0, half 2.0, half 20.>, %b]
  ret <4 x half> %x
}

define <4 x half> @phi_v4f16(i1 %c) {
; CHECK-LABEL: 'phi_v4f16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br i1 %c, label %a, label %b
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %x = phi <4 x half> [ <half 0xH3C00, half 0xH4000, half 0xH4200, half 0xH4400>, %a ], [ <half 0xH4000, half 0xH4400, half 0xH4600, half 0xH4800>, %b ]
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x half> %x
;
  br i1 %c, label %a, label %b
a:
  br label %d
b:
  br label %d
d:
  %x = phi <4 x half> [<half 1.0, half 2.0, half 3.0, half 4.0>, %a], [<half 2.0, half 4.0, half 6.0, half 8.0>, %b]
  ret <4 x half> %x
}

; The cost should be conservative and assume it will need to materialize the more expensive constant
define <4 x half> @phi_v4f16_cheap_and_expensive(i1 %c) {
; CHECK-LABEL: 'phi_v4f16_cheap_and_expensive'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br i1 %c, label %a, label %b
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %x = phi <4 x half> [ <half 0xH3C00, half 0xH3C00, half 0xH3C00, half 0xH3C00>, %a ], [ <half 0xH6F42, half 0xHECB8, half 0xH5DF6, half 0xH4A40>, %b ]
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x half> %x
;
  br i1 %c, label %a, label %b
a:
  br label %d
b:
  br label %d
d:
  %x = phi <4 x half> [<half 1.0, half 1.0, half 1.0, half 1.0>, %a], [<half 7432.0, half -4832.0, half 381.5, half 12.5>, %b]
  ret <4 x half> %x
}

define <4 x float> @phi_v4f32_splat(i1 %c) {
; CHECK-LABEL: 'phi_v4f32_splat'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br i1 %c, label %a, label %b
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %x = phi <4 x float> [ <float 1.000000e+00, float 1.000000e+00, float 1.000000e+00, float 1.000000e+00>, %a ], [ <float 2.000000e+00, float 2.000000e+00, float 2.000000e+00, float 2.000000e+01>, %b ]
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x float> %x
;
  br i1 %c, label %a, label %b
a:
  br label %d
b:
  br label %d
d:
  %x = phi <4 x float> [<float 1.0, float 1.0, float 1.0, float 1.0>, %a], [<float 2.0, float 2.0, float 2.0, float 20.>, %b]
  ret <4 x float> %x
}

define <4 x float> @phi_v4f32(i1 %c) {
; CHECK-LABEL: 'phi_v4f32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br i1 %c, label %a, label %b
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %x = phi <4 x float> [ <float 1.000000e+00, float 2.000000e+00, float 3.000000e+00, float 4.000000e+00>, %a ], [ <float 2.000000e+00, float 4.000000e+00, float 6.000000e+00, float 8.000000e+00>, %b ]
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x float> %x
;
  br i1 %c, label %a, label %b
a:
  br label %d
b:
  br label %d
d:
  %x = phi <4 x float> [<float 1.0, float 2.0, float 3.0, float 4.0>, %a], [<float 2.0, float 4.0, float 6.0, float 8.0>, %b]
  ret <4 x float> %x
}

; The cost should be conservative and assume it will need to materialize the more expensive constant
define <4 x float> @phi_v4f32_cheap_and_expensive(i1 %c) {
; CHECK-LABEL: 'phi_v4f32_cheap_and_expensive'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br i1 %c, label %a, label %b
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %x = phi <4 x float> [ <float 1.000000e+00, float 1.000000e+00, float 1.000000e+00, float 1.000000e+00>, %a ], [ <float 7.432000e+03, float -4.832000e+03, float 3.815000e+02, float 1.250000e+01>, %b ]
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x float> %x
;
  br i1 %c, label %a, label %b
a:
  br label %d
b:
  br label %d
d:
  %x = phi <4 x float> [<float 1.0, float 1.0, float 1.0, float 1.0>, %a], [<float 7432.0, float -4832.0, float 381.5, float 12.5>, %b]
  ret <4 x float> %x
}

define <4 x double> @phi_v4f64_splat(i1 %c) {
; CHECK-LABEL: 'phi_v4f64_splat'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br i1 %c, label %a, label %b
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %x = phi <4 x double> [ <double 1.000000e+00, double 1.000000e+00, double 1.000000e+00, double 1.000000e+00>, %a ], [ <double 2.000000e+00, double 2.000000e+00, double 2.000000e+00, double 2.000000e+01>, %b ]
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x double> %x
;
  br i1 %c, label %a, label %b
a:
  br label %d
b:
  br label %d
d:
  %x = phi <4 x double> [<double 1.0, double 1.0, double 1.0, double 1.0>, %a], [<double 2.0, double 2.0, double 2.0, double 20.>, %b]
  ret <4 x double> %x
}

define <4 x double> @phi_v4f64(i1 %c) {
; CHECK-LABEL: 'phi_v4f64'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br i1 %c, label %a, label %b
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %x = phi <4 x double> [ <double 1.000000e+00, double 2.000000e+00, double 3.000000e+00, double 4.000000e+00>, %a ], [ <double 2.000000e+00, double 4.000000e+00, double 6.000000e+00, double 8.000000e+00>, %b ]
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x double> %x
;
  br i1 %c, label %a, label %b
a:
  br label %d
b:
  br label %d
d:
  %x = phi <4 x double> [<double 1.0, double 2.0, double 3.0, double 4.0>, %a], [<double 2.0, double 4.0, double 6.0, double 8.0>, %b]
  ret <4 x double> %x
}

; The cost should be conservative and assume it will need to materialize the more expensive constant
define <4 x double> @phi_v4f64_cheap_and_expensive(i1 %c) {
; CHECK-LABEL: 'phi_v4f64_cheap_and_expensive'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br i1 %c, label %a, label %b
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: br label %d
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %x = phi <4 x double> [ <double 1.000000e+00, double 1.000000e+00, double 1.000000e+00, double 1.000000e+00>, %a ], [ <double 7.432000e+03, double -4.832000e+03, double 3.815000e+02, double 1.250000e+01>, %b ]
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x double> %x
;
  br i1 %c, label %a, label %b
a:
  br label %d
b:
  br label %d
d:
  %x = phi <4 x double> [<double 1.0, double 1.0, double 1.0, double 1.0>, %a], [<double 7432.0, double -4832.0, double 381.5, double 12.5>, %b]
  ret <4 x double> %x
}
