/*
Copyright 2023 The KubeVirt Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	v1alpha1 "kubevirt.io/api/instancetype/v1alpha1"
	scheme "kubevirt.io/client-go/generated/kubevirt/clientset/versioned/scheme"
)

// VirtualMachineInstancetypesGetter has a method to return a VirtualMachineInstancetypeInterface.
// A group's client should implement this interface.
type VirtualMachineInstancetypesGetter interface {
	VirtualMachineInstancetypes(namespace string) VirtualMachineInstancetypeInterface
}

// VirtualMachineInstancetypeInterface has methods to work with VirtualMachineInstancetype resources.
type VirtualMachineInstancetypeInterface interface {
	Create(ctx context.Context, virtualMachineInstancetype *v1alpha1.VirtualMachineInstancetype, opts v1.CreateOptions) (*v1alpha1.VirtualMachineInstancetype, error)
	Update(ctx context.Context, virtualMachineInstancetype *v1alpha1.VirtualMachineInstancetype, opts v1.UpdateOptions) (*v1alpha1.VirtualMachineInstancetype, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.VirtualMachineInstancetype, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.VirtualMachineInstancetypeList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.VirtualMachineInstancetype, err error)
	VirtualMachineInstancetypeExpansion
}

// virtualMachineInstancetypes implements VirtualMachineInstancetypeInterface
type virtualMachineInstancetypes struct {
	client rest.Interface
	ns     string
}

// newVirtualMachineInstancetypes returns a VirtualMachineInstancetypes
func newVirtualMachineInstancetypes(c *InstancetypeV1alpha1Client, namespace string) *virtualMachineInstancetypes {
	return &virtualMachineInstancetypes{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the virtualMachineInstancetype, and returns the corresponding virtualMachineInstancetype object, and an error if there is any.
func (c *virtualMachineInstancetypes) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.VirtualMachineInstancetype, err error) {
	result = &v1alpha1.VirtualMachineInstancetype{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("virtualmachineinstancetypes").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of VirtualMachineInstancetypes that match those selectors.
func (c *virtualMachineInstancetypes) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.VirtualMachineInstancetypeList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.VirtualMachineInstancetypeList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("virtualmachineinstancetypes").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested virtualMachineInstancetypes.
func (c *virtualMachineInstancetypes) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("virtualmachineinstancetypes").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a virtualMachineInstancetype and creates it.  Returns the server's representation of the virtualMachineInstancetype, and an error, if there is any.
func (c *virtualMachineInstancetypes) Create(ctx context.Context, virtualMachineInstancetype *v1alpha1.VirtualMachineInstancetype, opts v1.CreateOptions) (result *v1alpha1.VirtualMachineInstancetype, err error) {
	result = &v1alpha1.VirtualMachineInstancetype{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("virtualmachineinstancetypes").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(virtualMachineInstancetype).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a virtualMachineInstancetype and updates it. Returns the server's representation of the virtualMachineInstancetype, and an error, if there is any.
func (c *virtualMachineInstancetypes) Update(ctx context.Context, virtualMachineInstancetype *v1alpha1.VirtualMachineInstancetype, opts v1.UpdateOptions) (result *v1alpha1.VirtualMachineInstancetype, err error) {
	result = &v1alpha1.VirtualMachineInstancetype{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("virtualmachineinstancetypes").
		Name(virtualMachineInstancetype.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(virtualMachineInstancetype).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the virtualMachineInstancetype and deletes it. Returns an error if one occurs.
func (c *virtualMachineInstancetypes) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("virtualmachineinstancetypes").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *virtualMachineInstancetypes) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("virtualmachineinstancetypes").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched virtualMachineInstancetype.
func (c *virtualMachineInstancetypes) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.VirtualMachineInstancetype, err error) {
	result = &v1alpha1.VirtualMachineInstancetype{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("virtualmachineinstancetypes").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
