
> **Note**
> You want to add yourself to this list? Just fork the repository and open a PR with the required change.

# KubeVirt Adopters

| Type | Name | Since | Website | Use-Case |
|:-|:-|:-|:-|:-|
| End-User | arm | 2021 | [link](https://www.arm.com) | KubeVirt enables seamless transition from legacy Virtual Machine based workloads to cloud-native container platforms. Arm believes KubeVirt addresses this challenge, allowing Virtual Machines workloads to easily deploy and scale in the cloud and at the edge. <br><br>Arm is an active contributor to the project, focused on enabling and optimizing Kubevirt performance on aarch64 and working with the ecosystem to facilitate users in deploying their workloads on cloud-native platforms. |
| End-user| Civo | 2020 | [link](https://www.civo.com) | We are using KubeVirt as part of our stack to enable tenant cluster provisioning within Civo cloud. |
| End-user | CoreWeave | 2020 | [link](https://www.coreweave.com) | A Kubernetes native cloud provider with focus on GPUs at scale. KubeVirt allows us to co-locate non-containerizable workloads such as Virtual Desktops next to compute intensive containers executing on bare metal. All orchestrated via the Kubernetes API leveraging the same network policies and persistent volumes for both VM and containerized workloads. |
| End-user | Killercoda | 2022 | [link](https://killercoda.com) | Killercoda provides interactive learning environments based on VMs managed by KubeVirt. |
| End-user | NVIDIA | 2018 | [link](https://www.nvidia.com) | NVIDIA's latest computing platform is built on open-source projects like Kubernetes and KubeVirt to power products like [GeForce NOW](https://www.nvidia.com/en-us/geforce-now/) with more to come. |
| End-User | Genesis Cloud | 2022 | [link](https://genesiscloud.com/) | Genesis Cloud is basing its public cloud offering for instances with GPUs and other accelerators on kubevirt. |
| Integration | minikube | 2020 | [link](https://minikube.sigs.k8s.io) | |
| Integration | oVirt | 2020 | [link](https://www.ovirt.org/documentation/administration_guide/index.html#proc-adding-kubevirt-openshift-as-an-external-provider_external_providers) | oVirt can view and manage VMs that are running on a KubeVirt cluster. |
| Integration | okd | 2020 | [link](https://www.okd.io) | [OKD Virtualization](https://docs.okd.io/latest/virt/about_virt/about-virt.html) adds KubeVirt functionality to OKD. |
| Integration | osbuild-operator | 2022 | [link](https://github.com/project-flotta/osbuild-operator) | OSBuild-Operator uses KubeVirt to provision its internal worker VMs. |
| Integration | PITS Global Data Recovery Services | 2023 | [link](https://www.pitsdatarecovery.net/) | KubeVirt allows us to manage highly-loaded VMs and containers from one place. |
| Integration | Kasten by Veeam | 2022 | [link](https://docs.kasten.io/latest/usage/openshift_virtualization.html?highlight=kubevirt) | [Kasten K10](https://www.kasten.io/product/) manages KubeVirt and Red Hat OpenShift Virtualization VMs seamlessly for policy based automation of backup, disaster recovery, and application mobility across different Kubernetes versions, distributions, storage providers, and clouds. |
| Integration | Trilio | 2021 | [link](https://trilio.io/) | TrilioVault has been cloud-native since day one and protects the most demanding environments to maximize stability across all tenants. Our platform is built for flexibility across deployments, integrating seamlessly with Kubernetes, OpenStack and Red Hat Virtualization. That means we can equally backup and restore stateful and stateless applications based on VMs, Containers or VMs in Containers based on KubeVirt.  |
| Vendor | Deckhouse | 2022 | [link](https://deckhouse.io/) | Deckhouse is a No-Ops Kubernetes Platform by [Flant](https://flant.com/) which provides out-of-box solution to run any type of production-grade workloads. It includes monitoring, storage, and virtual machines based on KubeVirt. |
| Vendor | EQUINIX | | [link](https://metal.equinix.com/) | |
| Vendor | H3C | 2019 | [link](https://www.h3c.com/en/Products_Technology/Enterprise_Products/Cloud_Computing/Cloud_Computing_Products/H3C_CloudOS/H3C_CloudOS_full-stack/) | We distribute KubeVirt as part of CloudOS to enable VM workloads on Kubernetes at customer sites. |
| Vendor | KUBERMATIC | 2019 | [link](https://www.kubermatic.com/products/kubevirt/) | As a distributor we are running KubeVirt to enable VM workload on Kubermatic Virtualization. |
| Vendor | KUBESPHERE | 2020 | [link](https://kubesphere.cloud/en/ksv/) | KubeSphere Virtualization (KSV) provides lightweight VM management capability based on KubeVirt. |
| Vendor | Oracle | 2023 | [link](https://www.oracle.com) | As a distributor we are leveraging KubeVirt to enable VM workload on [Oracle Cloud Native Environment](https://www.oracle.com/linux/cloud-native-environment/), the Oracle multicloud and on-premises Kubernetes distribution. |
| Vendor | PLATFORM9 | | [link](https://platform9.com/managed-kubevirt/) | Run Legacy and Cloud-Native Applications on Platform9 |
| Vendor | Red Hat, Inc. | 2016 | [link](https://www.redhat.com) | As a distributor we are building OpenShift Virtualization on KubeVirt in order to enable VM workloads and -flows on Kubernetes. |
| Vendor | SUSE | 2020 | [link](https://www.suse.com/) | SUSE believes KubeVirt is the best open source way to handle Virtual Machines on Kubernetes today. We offer this additional possibility to our customers by leveraging KubeVirt in our products. |
| Vendor | Puzl | 2022 | [link](https://puzl.ee/) | As a cloud-native computing platform we want to provide users with seamless experience. Many users are familiar with cloud VMs, but not yet with Kubernetes, and with Kubevirt we are giving them a bridge to a cloud-native world to make their migration easier. |
