; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal -attributor-max-iterations-verify -attributor-annotate-decl-cs -attributor-max-iterations=3 -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC
;
;
;                            /---------------------------------------|
;                            |                /----------------------|----|
;                            |                |                /-----|    |
;                            V                V                V     |    |
;    void broker(int (*cb0)(int), int (*cb1)(int), int (*cb2)(int), int, int);
;
;    static int cb0(int zero) {
;      return zero;
;    }
;    static int cb1(int unknown) {
;      return unknown;
;    }
;    static int cb2(int unknown) {
;      cb0(0);
;      return unknown;
;    }
;    static int cb3(int unknown) {
;      return unknown;
;    }
;    static int cb4(int unknown) {
;      return unknown;
;    }
;
;    void foo() {
;      cb0(0);
;      cb3(1);
;      broker(cb0, cb1, cb0, 0, 1);
;      broker(cb1, cb2, cb2, 0, 1);
;      broker(cb3, cb2, cb3, 0, 1);
;      broker(cb4, cb4, cb4, 0, 1);
;    }
;
target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"

define internal i32 @cb0(i32 %zero) {
; CHECK: Function Attrs: nofree norecurse nosync nounwind willreturn memory(none)
; CHECK-LABEL: define {{[^@]+}}@cb0
; CHECK-SAME: (i32 [[ZERO:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret i32 0
;
entry:
  ret i32 %zero
}

define internal i32 @cb1(i32 %unknown) {
; CHECK: Function Attrs: nofree norecurse nosync nounwind willreturn memory(none)
; CHECK-LABEL: define {{[^@]+}}@cb1
; CHECK-SAME: (i32 noundef [[UNKNOWN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret i32 [[UNKNOWN]]
;
entry:
  ret i32 %unknown
}

define internal i32 @cb2(i32 %unknown) {
; TUNIT: Function Attrs: nofree norecurse nosync nounwind willreturn memory(none)
; TUNIT-LABEL: define {{[^@]+}}@cb2
; TUNIT-SAME: (i32 noundef [[UNKNOWN:%.*]]) #[[ATTR0]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    ret i32 [[UNKNOWN]]
;
; CGSCC: Function Attrs: nofree nosync nounwind willreturn memory(none)
; CGSCC-LABEL: define {{[^@]+}}@cb2
; CGSCC-SAME: (i32 noundef [[UNKNOWN:%.*]]) #[[ATTR1:[0-9]+]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    ret i32 [[UNKNOWN]]
;
entry:
  %call = call i32 @cb0(i32 0)
  ret i32 %unknown
}

define internal i32 @cb3(i32 %unknown) {
; CHECK: Function Attrs: nofree norecurse nosync nounwind willreturn memory(none)
; CHECK-LABEL: define {{[^@]+}}@cb3
; CHECK-SAME: (i32 noundef [[UNKNOWN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret i32 [[UNKNOWN]]
;
entry:
  ret i32 %unknown
}

define internal i32 @cb4(i32 %unknown) {
; CHECK: Function Attrs: nofree norecurse nosync nounwind willreturn memory(none)
; CHECK-LABEL: define {{[^@]+}}@cb4
; CHECK-SAME: (i32 noundef [[UNKNOWN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret i32 [[UNKNOWN]]
;
entry:
  ret i32 %unknown
}

define void @foo() {
; CHECK-LABEL: define {{[^@]+}}@foo() {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    call void @broker(ptr noundef nonnull @cb0, ptr noundef nonnull @cb1, ptr noundef nonnull @cb0, i32 noundef 0, i32 noundef 1)
; CHECK-NEXT:    call void @broker(ptr noundef nonnull @cb1, ptr noundef nonnull @cb2, ptr noundef nonnull @cb2, i32 noundef 0, i32 noundef 1)
; CHECK-NEXT:    call void @broker(ptr noundef nonnull @cb3, ptr noundef nonnull @cb2, ptr noundef nonnull @cb3, i32 noundef 0, i32 noundef 1)
; CHECK-NEXT:    call void @broker(ptr noundef nonnull @cb4, ptr noundef nonnull @cb4, ptr noundef nonnull @cb4, i32 noundef 0, i32 noundef 1)
; CHECK-NEXT:    ret void
;
entry:
  %call = call i32 @cb0(i32 0)
  %call1 = call i32 @cb3(i32 1)
  call void @broker(ptr nonnull @cb0, ptr nonnull @cb1, ptr nonnull @cb0, i32 0, i32 1)
  call void @broker(ptr nonnull @cb1, ptr nonnull @cb2, ptr nonnull @cb2, i32 0, i32 1)
  call void @broker(ptr nonnull @cb3, ptr nonnull @cb2, ptr nonnull @cb3, i32 0, i32 1)
  call void @broker(ptr nonnull @cb4, ptr nonnull @cb4, ptr nonnull @cb4, i32 0, i32 1)
  ret void
}

declare !callback !3 void @broker(ptr, ptr, ptr, i32, i32)

!0 = !{i64 0, i64 3, i1 false}
!1 = !{i64 1, i64 4, i1 false}
!2 = !{i64 2, i64 3, i1 false}
!3 = !{!0, !2, !1}
;.
; TUNIT: attributes #[[ATTR0]] = { nofree norecurse nosync nounwind willreturn memory(none) }
;.
; CGSCC: attributes #[[ATTR0]] = { nofree norecurse nosync nounwind willreturn memory(none) }
; CGSCC: attributes #[[ATTR1]] = { nofree nosync nounwind willreturn memory(none) }
;.
; CHECK: [[META0:![0-9]+]] = !{!1, !2, !3}
; CHECK: [[META1:![0-9]+]] = !{i64 0, i64 3, i1 false}
; CHECK: [[META2:![0-9]+]] = !{i64 2, i64 3, i1 false}
; CHECK: [[META3:![0-9]+]] = !{i64 1, i64 4, i1 false}
;.
