; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel -march=amdgcn -verify-machineinstrs -amdgpu-mem-intrinsic-expand-size=3 %s -o - | FileCheck -check-prefix=LOOP %s
; RUN: llc -global-isel -march=amdgcn -verify-machineinstrs -amdgpu-mem-intrinsic-expand-size=5 %s -o - | FileCheck -check-prefix=UNROLL %s

declare void @llvm.memset.p1.i32(ptr addrspace(1), i8, i32, i1)

define amdgpu_cs void @memset_p1i8(ptr addrspace(1) %dst, i8 %val) {
; LOOP-LABEL: memset_p1i8:
; LOOP:       ; %bb.0: ; %loadstoreloop.preheader
; LOOP-NEXT:    s_mov_b64 s[0:1], 0
; LOOP-NEXT:    s_mov_b32 s2, 0
; LOOP-NEXT:    s_mov_b32 s3, 0xf000
; LOOP-NEXT:    v_mov_b32_e32 v4, s1
; LOOP-NEXT:    v_mov_b32_e32 v3, s0
; LOOP-NEXT:  .LBB0_1: ; %loadstoreloop
; LOOP-NEXT:    ; =>This Inner Loop Header: Depth=1
; LOOP-NEXT:    v_add_i32_e32 v5, vcc, v0, v3
; LOOP-NEXT:    v_addc_u32_e32 v6, vcc, v1, v4, vcc
; LOOP-NEXT:    v_add_i32_e32 v3, vcc, 1, v3
; LOOP-NEXT:    v_addc_u32_e32 v4, vcc, 0, v4, vcc
; LOOP-NEXT:    v_cmp_gt_u32_e32 vcc, 4, v3
; LOOP-NEXT:    buffer_store_byte v2, v[5:6], s[0:3], 0 addr64
; LOOP-NEXT:    s_cbranch_vccnz .LBB0_1
; LOOP-NEXT:  ; %bb.2: ; %split
; LOOP-NEXT:    s_endpgm
;
; UNROLL-LABEL: memset_p1i8:
; UNROLL:       ; %bb.0:
; UNROLL-NEXT:    s_mov_b32 s2, 0
; UNROLL-NEXT:    s_mov_b32 s3, 0xf000
; UNROLL-NEXT:    s_mov_b64 s[0:1], 0
; UNROLL-NEXT:    buffer_store_byte v2, v[0:1], s[0:3], 0 addr64
; UNROLL-NEXT:    buffer_store_byte v2, v[0:1], s[0:3], 0 addr64 offset:1
; UNROLL-NEXT:    buffer_store_byte v2, v[0:1], s[0:3], 0 addr64 offset:2
; UNROLL-NEXT:    buffer_store_byte v2, v[0:1], s[0:3], 0 addr64 offset:3
; UNROLL-NEXT:    s_endpgm
  call void @llvm.memset.p1.i32(ptr addrspace(1) %dst, i8 %val, i32 4, i1 false)
  ret void
}
