# DRBD9

This repository contains the Linux kernel code for DRBD9.

DRBD, developed by [LINBIT](https://www.linbit.com), is a software that allows RAID 1 functionality over
TCP/IP and RDMA for GNU/Linux. DRBD is a block device which is designed to build high availability clusters and
software defined storage by providing a virtual shared device which keeps disks in nodes synchronised using
TCP/IP or RDMA. This simulates RAID 1 but avoids the use of uncommon hardware (shared SCSI buses or Fibre Channel).

# Using DRBD
Please read the user-guide provided at [docs.linbit.com](https://docs.linbit.com).

# Support
For further products and professional support, please
[contact](http://links.linbit.com/support) us.

# Contributing
Development is coordinated via [mailing lists](http://lists.linbit.com). Currently, we do not intend to use
github issue tracking/github PRs.

# Building DRBD

Since version 9.0.20, DRBD has been using a kernel backwards compatibility system
based on [Coccinelle](https://github.com/coccinelle/coccinelle) semantic patches.
While this has many advantages, it also makes it a little harder for "casual"
developers to build DRBD from the git sources. The problem is that we require a
very recent version of `spatch` (at least 1.0.8 at time of writing), and most
distributions only have relatively old versions in their repositories.

## From git

For users wishing to build DRBD from its git sources, here are a few options:
1. Use a recent kernel. When building against a recent(ish) upstream kernel,
   chances are you won't even have to use any of the compat features, which
   means you won't require compatibility patches and in turn don't need spatch
   installed.
2. On Ubuntu 18.04 and newer, use a recent spatch version from the
   [Coccinelle PPA](https://launchpad.net/~npalix/+archive/ubuntu/coccinelle).
   This provides (at time of writing) version 1.0.8, which is recent enough to
   build DRBD.
3. Build and install spatch from source. This will also give you a version that
   is recent enough to build DRBD.

## From a release tarball

For use cases where it is appropriate to just build DRBD from a release tarball,
here are some options:
1. Use a distribution kernel and rely on the shipped "compat patch cache". We
   pre-generate compatibility patches for a list of commonly used distribution
   kernels and ship them with every release tarball. If your kernel matches one
   of those in the cache, you won't need spatch because the cached patch will be
   applied directly.
2. For all other kernels, you can use LINBIT's "spatch as a service" online
   service, which transparently and automatically generates compatibility
   patches based on your kernels feature set.
3. If you are using an exotic kernel and you do not have internet access or
   otherwise can't or don't want to use "spatch as a service", you will have to
   install a recent version of coccinelle (see above).

For a release tarball, these options should be handled transparently for the
user. In other words, if you download a tarball and type "make", it should work
in next to all cases.

# Releases
Releases generated by git tags on github are snapshots of the git repository at the given time. You most
likely do not want to use these. They might lack things such as generated man pages, the `configure` script,
and other generated files. If you want to build from a tarball, use the ones [provided by us](https://www.linbit.com/en/drbd-community/drbd-download/).
