#!/bin/sh
# Reproducer for https://bugzilla.samba.org/show_bug.cgi?id=14908

if [ $# -lt 2 ]; then
    echo "Usage: $0 NET CONFFILE SERVER_IP"
    exit 1
fi

NET="$1"; shift
CONFFILE="$1"; shift
SERVER_IP="$1"; shift

export UID_WRAPPER_ROOT=1

incdir=`dirname $0`/../../../testprogs/blackbox
. $incdir/subunit.sh

failed=0

test_net_ads_user()
{
	cmd='UID_WRAPPER_INITIAL_RUID=0 UID_WRAPPER_INITIAL_EUID=0 $VALGRIND $NET rpc user --configfile="$CONFFILE" -S "$SERVER_IP" -P'
	eval echo "$cmd"
	out=$(eval $cmd)
	ret=$?
	if [ $ret -ne 0 ]; then
		echo "Failed to get user list"
		return 1
	fi
}

testit "net_ads_user" test_net_ads_user || failed=`expr $failed + 1`

testok $0 $failed
