/*
 *   IBM Omni driver
 *   Copyright (c) International Business Machines Corp., 2000
 *
 *   This library is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published
 *   by the Free Software Foundation; either version 2.1 of the License, or
 *   (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Idea borrowed from http://hpinkjet.sourceforge.net
 */
#ifndef _OmniServer
#define _OmniServer

#include <stddef.h>

/*
 *  Printer Driver Communications (PDC)
 */

#define PDC_VERSION "0.1.0"

typedef enum _PrinterDriverCommunicationCommand {
   // 2.0 Return codes
   PDCCMD_ACK                                    = 0x00000001,
   PDCCMD_NACK,
   PDCCMD_UNSUPPORTED,
   PDCCMD_WARNING,

   // 2.1 Session management
   PDCCMD_INITIALIZE_SESSION                     = 0x00000100,
   PDCCMD_CLOSE_SESSION,
   PDCCMD_IS_CMD_SUPPORTED,
   PDCMD_SET_TRANSLATABLE_LANGUAGE,
   PDCMD_GET_TRANSLATABLE_LANGUAGE,
   PDCMD_QUERY_TRANSLATABLE_LANGUAGES,

   // 2.2 Device management
   PDCCMD_ENUM_SHORT_DEVICES                     = 0x00000200,
   PDCCMD_ENUM_LONG_DEVICES,
   PDCCMD_SET_DEVICE_NAME,
   PDCCMD_IS_VALID_DEVICE_NAME,
   PDCCMD_GET_PDL_INFO,

   // 2.3 Job Properties
   PDCCMD_GET_JOB_PROPERTIES                     = 0x00000300,
   PDCCMD_SET_JOB_PROPERTIES,
   PDCCMD_GET_JOB_PROPERTY,
   PDCCMD_GET_JOB_PROPERTY_TYPE,
   PDCMD_XLATE_JOB_PROPERTY_KEY_VALUE,

   // 2.4 Printer Properties
   PDCCMD_SET_PRINTER_PROPERTIES                 = 0x00000400,
   PDCCMD_QUERY_CURRENT_PRINTER_PROPERTIES,
   PDCCMD_LIST_PRINTER_PROPERTY_KEYS,
   PDCCMD_LIST_DEVICE_PRINTER_PROPERTY_KEYS,
   PDCCMD_LIST_PRINTER_PROPERTY_KEY_VALUES,
   PDCCMD_GET_PRINTER_PROPERTY,
   PDCCMD_GET_PRINTER_PROPERTY_TYPE,
   PDCMD_XLATE_PRINTER_PROPERTY_KEY_VALUE,

   // 2.5 Job Control
   PDCCMD_NEW_DEVICE                             = 0x00000500,
   PDCCMD_SET_OUTPUT_STREAM,
   PDCCMD_SET_ERROR_STREAM,
   PDCCMD_BEGIN_JOB,
   PDCCMD_START_PAGE,
   PDCCMD_END_PAGE,
   PDCCMD_END_JOB,
   PDCCMD_ABORT_PAGE,
   PDCCMD_ABORT_JOB,

   // 2.6 Job Data
   PDCCMD_MODE_IS_RENDERER                       = 0x00000600,
   PDCCMD_ATTACH_BUFFER1,
   PDCCMD_ATTACH_BUFFER2,
   PDCCMD_DETACH_BUFFER1,
   PDCCMD_DETACH_BUFFER2,
   PDCCMD_RASTERIZE,
   PDCMD_QUERY_INPUT_FORMATS,
   PDCMD_SET_INPUT_FORMAT,

   // 2.7 Job Information (Capabilities)
   PDCMD_IS_COLOR_PRINTER                        = 0x00000700,
   PDCMD_HAS_HARDWARE_COPY,

   // 2.8 Private PDC to pdc support
   PDCCMD_PUSH_CURRENT_GAMMA                     = 0x40000000,
   PDCCMD_PUSH_CURRENT_BOOKLET,
   PDCCMD_PUSH_CURRENT_COPIES,
   PDCCMD_PUSH_CURRENT_DITHER_ID,
   PDCCMD_PUSH_CURRENT_FORM,
   PDCCMD_PUSH_CURRENT_JOGGING,
   PDCCMD_PUSH_CURRENT_MEDIA,
   PDCCMD_PUSH_CURRENT_NUP,
   PDCCMD_PUSH_CURRENT_ORIENTATION,
   PDCCMD_PUSH_CURRENT_OUTPUT_BIN,
   PDCCMD_PUSH_CURRENT_PRINT_MODE,
   PDCCMD_PUSH_CURRENT_RESOLUTION,
   PDCCMD_PUSH_CURRENT_SCALING,
   PDCCMD_PUSH_CURRENT_SHEET_COLLATE,
   PDCCMD_PUSH_CURRENT_SIDE,
   PDCCMD_PUSH_CURRENT_STITCHING,
   PDCCMD_PUSH_CURRENT_TRAY,
   PDCCMD_PUSH_CURRENT_TRIMMING,

   // 2.9 Omni Application Support (Presentation Space Capabilities)
   PDCCMD_GET_VERSION                            = 0x80000000,
   PDCCMD_GET_DRIVER_NAME,
   PDCCMD_GET_DEVICE_NAME,
   PDCCMD_GET_SHORT_NAME,
   PDCCMD_GET_LIBRARY_NAME,
   PDCCMD_GET_OMNI_CLASS,

   PDCCMD_QUERY_CURRENT_GAMMA                    = 0x80000100,
   PDCCMD_QUERY_CURRENT_BOOKLET,
   PDCCMD_QUERY_CURRENT_COPIES,
   PDCCMD_QUERY_CURRENT_DITHER_ID,
   PDCCMD_QUERY_CURRENT_FORM,
   PDCCMD_QUERY_CURRENT_JOGGING,
   PDCCMD_QUERY_CURRENT_MEDIA,
   PDCCMD_QUERY_CURRENT_NUP,
   PDCCMD_QUERY_CURRENT_ORIENTATION,
   PDCCMD_QUERY_CURRENT_OUTPUT_BIN,
   PDCCMD_QUERY_CURRENT_PRINT_MODE,
   PDCCMD_QUERY_CURRENT_RESOLUTION,
   PDCCMD_QUERY_CURRENT_SCALING,
   PDCCMD_QUERY_CURRENT_SHEET_COLLATE,
   PDCCMD_QUERY_CURRENT_SIDE,
   PDCCMD_QUERY_CURRENT_STITCHING,
   PDCCMD_QUERY_CURRENT_TRAY,
   PDCCMD_QUERY_CURRENT_TRIMMING,

   PDCCMD_HAS_CAPABILITY                         = 0x80000200,
   PDCCMD_HAS_RASTER_CAPABILITY,
   PDCCMD_HAS_DEVICE_OPTION,

   PDCCMD_IS_BOOKLET_SUPPORTED                   = 0x80000300,
   PDCCMD_IS_COPIES_SUPPORTED,
   PDCCMD_IS_DITHER_ID_SUPPORTED,
   PDCCMD_IS_FORM_SUPPORTED,
   PDCCMD_IS_JOGGING_SUPPORTED,
   PDCCMD_IS_MEDIA_SUPPORTED,
   PDCCMD_IS_NUP_SUPPORTED,
   PDCCMD_IS_ORIENTATION_SUPPORTED,
   PDCCMD_IS_OUTPUT_BIN_SUPPORTED,
   PDCCMD_IS_PRINT_MODE_SUPPORTED,
   PDCCMD_IS_RESOLUTION_SUPPORTED,
   PDCCMD_IS_SCALING_SUPPORTED,
   PDCCMD_IS_SHEET_COLLATE_SUPPORTED,
   PDCCMD_IS_SIDE_SUPPORTED,
   PDCCMD_IS_STITCHING_SUPPORTED,
   PDCCMD_IS_TRAY_SUPPORTED,
   PDCCMD_IS_TRIMMING_SUPPORTED,

   PDCCMD_ENUM_BOOKLETS                          = 0x80000400,
   PDCCMD_ENUM_COPIES,
   PDCCMD_ENUM_DITHER_IDS,
   PDCCMD_ENUM_FORMS,
   PDCCMD_ENUM_JOGGINGS,
   PDCCMD_ENUM_MEDIAS,
   PDCCMD_ENUM_NUPS,
   PDCCMD_ENUM_ORIENTATIONS,
   PDCCMD_ENUM_OUTPUT_BINS,
   PDCCMD_ENUM_PRINT_MODES,
   PDCCMD_ENUM_RESOLUTIONS,
   PDCCMD_ENUM_SCALINGS,
   PDCCMD_ENUM_SHEET_COLLATES,
   PDCCMD_ENUM_SIDES,
   PDCCMD_ENUM_STITCHINGS,
   PDCCMD_ENUM_TRAYS,
   PDCCMD_ENUM_TRIMMINGS,
   PDCCMD_ENUM_INSTANCE_PROPS

} PDC_CMD, *PPDC_CMD;

typedef enum _PrinterDriverCommunicationFormat {
   PDCFMT_NULL          = 1,
   PDCFMT_STRING,
   PDCFMT_BINARY,
   PDCFMT_BOOLEAN,
   PDCFMT_INTEGER,
   PDCFMT_LONG,
   PDCFMT_STRING_ARRAY,
   PDCFMT_XML_DATA
} PDC_FMT, *PPDC_FMT;

typedef struct _PrinterDriverCommunicationPacket {
   PDC_CMD eCommand;          // Printer Driver Command
   size_t  cbLength;          // Length of this packet
   PDC_FMT eFormat;           // Type of the following data
   char    achCommandLine[1]; // Start of data
} __attribute__ ((aligned (1))) __attribute__ ((packed))
  PDC_PACKET, *PPDC_PACKET;

#endif
