// SPDX-FileCopyrightText: 2024 SUSE LLC
//
// SPDX-License-Identifier: Apache-2.0

package templates

import (
	"io"
	"text/template"
)

const sshTemplate = `# uyuni-proxy-ssh.service, generated by mgrpxy
# Use an uyuni-proxy-ssh.service.d/local.conf file to override

[Unit]
Description=Uyuni proxy ssh container service
Wants=network.target
After=network-online.target
BindsTo=uyuni-proxy-pod.service
After=uyuni-proxy-pod.service

[Service]
Environment=PODMAN_SYSTEMD_UNIT=%n
{{- if .HTTPProxyFile }}
EnvironmentFile={{ .HTTPProxyFile }}
{{- end }}
Restart=on-failure
ExecStartPre=/bin/rm -f %t/uyuni-proxy-ssh.pid %t/uyuni-proxy-ssh.ctr-id

ExecStart=/bin/sh -c '/usr/bin/podman run \
	--conmon-pidfile %t/uyuni-proxy-ssh.pid \
	--cidfile %t/uyuni-proxy-ssh.ctr-id \
	--cgroups=no-conmon \
	--pod-id-file %t/uyuni-proxy-pod.pod-id -d \
	--replace -dt \
	-v /etc/uyuni/proxy:/etc/uyuni:ro \
	--name uyuni-proxy-ssh \
	${UYUNI_IMAGE}'

ExecStop=/usr/bin/podman stop --ignore --cidfile %t/uyuni-proxy-ssh.ctr-id -t 10
ExecStopPost=/usr/bin/podman rm --ignore -f --cidfile %t/uyuni-proxy-ssh.ctr-id
PIDFile=%t/uyuni-proxy-ssh.pid
TimeoutStopSec=60
Type=forking

[Install]
WantedBy=multi-user.target default.target
`

// SSHTemplateData SSH information to create systemd file.
type SSHTemplateData struct {
	HTTPProxyFile string
}

// Render will create the systemd configuration file.
func (data SSHTemplateData) Render(wr io.Writer) error {
	t := template.Must(template.New("service").Parse(sshTemplate))
	return t.Execute(wr, data)
}
