// SPDX-FileCopyrightText: 2025 SUSE LLC
//
// SPDX-License-Identifier: Apache-2.0

package templates

import (
	"io"
	"strings"
	"text/template"

	"github.com/uyuni-project/uyuni-tools/shared/types"
)

const inspectTemplate = `
# inspect.sh, generated by mgradm
{{- range .Values }}
echo "{{ .Variable }}=$({{ .CLI }})"
{{- end }}
exit 0
`

// InspectTemplateData represents information used to create inspect script.
type InspectTemplateData struct {
	Values []types.InspectData
}

// Render will create inspect script.
func (data InspectTemplateData) Render(wr io.Writer) error {
	t := template.Must(template.New("inspect").Parse(inspectTemplate))
	return t.Execute(wr, data)
}

// GenerateScriptString creates the inspector script and returns it as a string.
func (data InspectTemplateData) GenerateScript() (string, error) {
	scriptBuilder := new(strings.Builder)
	if err := data.Render(scriptBuilder); err != nil {
		return "", err
	}

	return scriptBuilder.String(), nil
}
