// SPDX-FileCopyrightText: 2025 SUSE LLC
//
// SPDX-License-Identifier: Apache-2.0

package podman

import (
	"testing"

	"github.com/uyuni-project/uyuni-tools/shared/testutils"
	"github.com/uyuni-project/uyuni-tools/shared/utils"
)

func TestHostInspectorGenerate(t *testing.T) {
	inspector := NewHostInspector()
	script, err := inspector.GenerateScript()
	if err != nil {
		t.Errorf("Unexpected error %s", err)
	}

	expected := `
# inspect.sh, generated by mgradm
echo "scc_username=$(cat /etc/zypp/credentials.d/SCCcredentials 2>/dev/null | grep username | cut -d= -f2 || true)"
echo "scc_password=$(cat /etc/zypp/credentials.d/SCCcredentials 2>/dev/null | grep password | cut -d= -f2 || true)"
echo "has_uyuni_server=$(systemctl list-unit-files uyuni-server.service >/dev/null && echo true || echo false)"
echo "has_salt_minion=$(systemctl list-unit-files venv-salt-minion.service >/dev/null && echo true || echo false)"
exit 0
`

	testutils.AssertEquals(t, "Wrongly generated script", expected, script)
}

func TestHostInspectorParse(t *testing.T) {
	content := `
scc_username=myuser
scc_password=mysecret
has_uyuni_server=true
`

	actual, err := utils.ReadInspectData[HostInspectData]([]byte(content))
	if err != nil {
		t.Fatalf("Unexpected error: %s", err)
	}

	testutils.AssertEquals(t, "Invalid SCC username", "myuser", actual.SCCUsername)
	testutils.AssertEquals(t, "Invalid SCC password", "mysecret", actual.SCCPassword)
	testutils.AssertTrue(t, "HasUyuniServer should be true", actual.HasUyuniServer)
}
