libstorage-ng
=============

libstorage-ng is the designated successor of
[libstorage](https://github.com/openSUSE/libstorage), a C++ library used by
[YaST](https://github.com/yast) to perform most storage related tasks.

The main idea of libstorage-ng compared to libstorage is to keep all
information about storage devices in a
[graph](https://en.wikipedia.org/wiki/Graph_(discrete_mathematics)) instead of
lists. For more information have a look at the [overview](doc/overview.md).


Requirements
------------

Some required tools for compiling and testing libstorage-ng are:

gcc-c++ boost-devel libjson-c-devel libxml2-devel libtool doxygen
graphviz python3-devel python3-networkx ruby ruby-devel
rubygem-test-unit swig >= 3.0.3 and != 3.0.8 (from
[YaST:storage-ng](https://build.opensuse.org/project/show/YaST:storage-ng))

In addition to the previous packages, add these distribution-specific packages as well.

For some openSUSE/SUSE distributions the naming of `rubygem-test-unit` might be the following:

ruby2.1-rubygem-test-unit

For Fedora:

rubypick


Compiling
---------

```sh
make -f Makefile.repo
make -j$(nproc)
```

Some files used to generate the bindings must be updated using tools
in the utils directory.

When changing any exception specification (those in comments for
doxygen) you have to run ```./generate-catches.py >
../bindings/storage-catches.i```.

When changing the class hierarchy of classes derived from Device or
Holder you have to run ```./generate-downcast.py >
../bindings/storage-downcast.i```.

Make sure the documentation generated by doxygen is up-to-date before
running the utils above.


Running Unit Tests
------------------

```sh
make -j$(nproc) install DESTDIR=/tmp/scratch
make -j$(nproc) check LIBSTORAGE_LOCALEDIR=/tmp/scratch/usr/share/locale LIBSTORAGE_CONFDIR=/tmp/scratch/usr/share/libstorage
```


Making an RPM
-------------

```sh
make -f Makefile.repo
make package
cd package
osc build --local-package --alternative-project=openSUSE:Factory
```


Creating Changes And Package And Submitting To OBS
--------------------------------------------------

Creating the changes file and tar archive are handled by jenkins
using [linuxrc-devtools](https://github.com/openSUSE/linuxrc-devtools).

Additional files needed for OBS building are placed in the `obs`
subdirectory.

You can generate a preview of the changes file by running

```sh
make changes
```

and create the tar.xz source archive by running

```sh
make archive
```

Package versions are tracked by setting version tags in git. The last
version digit is auto-increased with every OBS commit.

**The `VERSION` file is auto-generated from the latest git tag.**

The version can be set manually by setting the appropriate tag in git. As
jenkins also sets version tags during the auto-submission process it is
needed to turn off the jenkins job temporarily. So, to set the version to a
specific number, follow these steps:

1. disable the `libstorage-ng-master` project on the internal jenkins node
2. merge your latest changes
3. set desired version tag - **Don't forget to push tags!**
4. re-enable the `libstorage-ng-master` project
5. trigger new build (or wait)

Remember, version tags should be `X.Y.Z` for master and `BRANCH-X.Y.Z` for other branches.

For a more detailed description about the handling of version numbers and changelog entries
look [here](https://github.com/openSUSE/linuxrc-devtools/blob/master/workflow.md).


Maintenance updates
-------------------

Jenkins will auto-submit only the `master` branch. Other branches usually imply a maintenance update.

To trigger updates for these branches, go to the `libstorage-ng-master`
project on our internal jenkins node. Choose `Build with Parameters` and
select the desired target.


Package Versions
----------------

Versioning follows [YaST](http://yastgithubio.readthedocs.io/en/latest/versioning)'s versioning scheme.

Currently this means

- 4.2.X for the `master` branch submitted to `Factory` and `SLE-15-SP2`
- 4.1.X for the `SLE-15-SP1` branch submitted to `SLE-15-SP1:Update`
- 3.3.X for the `SLE-15-GA` branch submitted to `SLE-15:Update`


Code Documentation
------------------

```sh
xdg-open doc/autodocs/html/index.html
```

See especially the class hierarchy:

```sh
xdg-open doc/autodocs/html/inherits.html
```

CI
--

For continuous integration GitHub Actions are used.

