# Unix SMB/CIFS implementation.
#
# Copyright (C) Samuel Cabrero <scabrero@suse.de> 2017
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import samba.tests
import os

class NTLMAuthDefaultDomainTests(samba.tests.NTLMAuthTestCase):

    def test_winbind_empty_domain_arg(self):
        username = os.environ["DC_USERNAME"]
        password = os.environ["DC_PASSWORD"]
        domain = ""
        self.run_helper(username, password, domain)

        self.writeLine(self.client_out, "YR")
        buf = self.readLine(self.client_in)
        self.assertEqual(buf.count("YR ", 0, 3), 1)

        self.writeLine(self.server_out, buf)
        buf = self.readLine(self.server_in)
        self.assertEqual(buf.count("TT ", 0, 3), 1)

        self.writeLine(self.client_out, buf)
        buf = self.readLine(self.client_in)
        self.assertEqual(buf.count("AF ", 0, 3),  1)

        # Client sends 'AF <base64 blob>' but server expects 'KK <base64 blob>'
        buf = buf.replace("AF", "KK", 1)

        self.writeLine(self.server_out, buf)
        buf = self.readLine(self.server_in)
        self.assertEqual(buf.count("AF ", 0, 3), 1)

    def test_winbind_empty_domain_part(self):
        username = "/" + os.environ["DC_USERNAME"]
        password = os.environ["DC_PASSWORD"]
        self.run_helper(username, password)

        self.writeLine(self.client_out, "YR")
        buf = self.readLine(self.client_in)
        self.assertEqual(buf.count("YR ", 0, 3), 1)

        self.writeLine(self.server_out, buf)
        buf = self.readLine(self.server_in)
        self.assertEqual(buf.count("TT ", 0, 3), 1)

        self.writeLine(self.client_out, buf)
        buf = self.readLine(self.client_in)
        self.assertEqual(buf.count("AF ", 0, 3),  1)

        # Client sends 'AF <base64 blob>' but server expects 'KK <base64 blob>'
        buf = buf.replace("AF", "KK", 1)

        self.writeLine(self.server_out, buf)
        buf = self.readLine(self.server_in)
        self.assertEqual(buf.count("AF ", 0, 3), 1)

    def test_winbind_domain_arg(self):
        username = os.environ["DC_USERNAME"]
        password = os.environ["DC_PASSWORD"]
        domain = os.environ["DOMAIN"]
        self.run_helper(username, password, domain)

        self.writeLine(self.client_out, "YR")
        buf = self.readLine(self.client_in)
        self.assertEqual(buf.count("YR ", 0, 3), 1)

        self.writeLine(self.server_out, buf)
        buf = self.readLine(self.server_in)
        self.assertEqual(buf.count("TT ", 0, 3), 1)

        self.writeLine(self.client_out, buf)
        buf = self.readLine(self.client_in)
        self.assertEqual(buf.count("AF ", 0, 3),  1)

        # Client sends 'AF <base64 blob>' but server expects 'KK <base64 blob>'
        buf = buf.replace("AF", "KK", 1)

        self.writeLine(self.server_out, buf)
        buf = self.readLine(self.server_in)
        self.assertEqual(buf.count("AF ", 0, 3), 1)

    def test_winbind_domain_part(self):
        username = os.environ["DOMAIN"] + "/" + os.environ["DC_USERNAME"]
        password = os.environ["DC_PASSWORD"]
        self.run_helper(username, password)

        self.writeLine(self.client_out, "YR")
        buf = self.readLine(self.client_in)
        self.assertEqual(buf.count("YR ", 0, 3), 1)

        self.writeLine(self.server_out, buf)
        buf = self.readLine(self.server_in)
        self.assertEqual(buf.count("TT ", 0, 3), 1)

        self.writeLine(self.client_out, buf)
        buf = self.readLine(self.client_in)
        self.assertEqual(buf.count("AF ", 0, 3),  1)

        # Client sends 'AF <base64 blob>' but server expects 'KK <base64 blob>'
        buf = buf.replace("AF", "KK", 1)

        self.writeLine(self.server_out, buf)
        buf = self.readLine(self.server_in)
        self.assertEqual(buf.count("AF ", 0, 3), 1)
