/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>
 */

/* Messages sent to the logging daemon */
#define	LD_LOGIT	2
#define MAXENTITY	64

/* Message contains following header, followed by the text (char[]) itself */
struct LogDaemonMsgHdr_s {
	int		msgtype;
	int		facility;
	int		priority;
	int		msglen;
	gboolean	use_pri_str;
	int		entity_pid;
	char		entity[MAXENTITY];
	TIME_T		timestamp;
};
typedef	struct LogDaemonMsgHdr_s	LogDaemonMsgHdr;
