cmake_minimum_required(VERSION 3.16)
include(RunCMake)

# Function to build and install a project.
function(run_install_test case)
  set(RunCMake_TEST_BINARY_DIR ${RunCMake_BINARY_DIR}/${case}-build)
  set(RunCMake_TEST_NO_CLEAN 1)
  file(REMOVE_RECURSE "${RunCMake_TEST_BINARY_DIR}")
  file(MAKE_DIRECTORY "${RunCMake_TEST_BINARY_DIR}")
  run_cmake(${case})
  run_cmake_command(${case}-build ${CMAKE_COMMAND} --build . --config Debug)
  # Check "all" components.
  set(CMAKE_INSTALL_PREFIX ${RunCMake_TEST_BINARY_DIR}/root-all)
  run_cmake_command(${case}-all ${CMAKE_COMMAND} -DCMAKE_INSTALL_PREFIX=${CMAKE_INSTALL_PREFIX} -DBUILD_TYPE=Debug -P cmake_install.cmake)
endfunction()

if(CMAKE_HOST_SYSTEM_NAME STREQUAL "Darwin")
  if(NOT CMake_INSTALL_NAME_TOOL_BUG)
    run_install_test(macos)
    run_install_test(macos-unresolved)
    run_install_test(macos-conflict)
    run_install_test(macos-notfile)
  endif()
  run_cmake(project)
  run_cmake(badargs1)
  run_cmake(badargs2)
elseif(CMAKE_HOST_SYSTEM_NAME STREQUAL "Windows")
  run_install_test(windows)
  run_install_test(windows-unresolved)
  run_install_test(windows-conflict)
  run_install_test(windows-notfile)
  run_cmake(project)
  run_cmake(badargs1)
  run_cmake(badargs2)
elseif(CMAKE_HOST_SYSTEM_NAME STREQUAL "Linux")
  if(DEFINED ENV{LDFLAGS})
    # Some setups prebake disable-new-dtags into LDFLAGS
    string(REPLACE "-Wl,--disable-new-dtags" "" new_ldflags "$ENV{LDFLAGS}")
    set(ENV{LDFLAGS} "${new_ldflags}")
  endif()

  if(NOT CMAKE_C_COMPILER_ID MATCHES "^XL")
    run_install_test(linux)
  endif()
  run_install_test(linux-unresolved)
  run_install_test(linux-conflict)
  run_install_test(linux-notfile)
  run_cmake(project)
  run_cmake(badargs1)
  run_cmake(badargs2)
else()
  run_cmake(unsupported)
endif()

run_install_test(variable-propagation)
