; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i386-apple-macosx -mattr=+sse2 | FileCheck %s --check-prefix=X86
; RUN: llc < %s -mtriple=x86_64-apple-macosx -mattr=+sse2 | FileCheck %s --check-prefix=X64

; We get this right for x86-64, but on x86-32 the code is less optimal.
; See: https://github.com/llvm/llvm-project/issues/64174
define noundef float @i8_to_fp(i8 noundef zeroext %0) {
; X86-LABEL: i8_to_fp:
; X86:       ## %bb.0:
; X86-NEXT:    pushl %eax
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cvtsi2ss %eax, %xmm0
; X86-NEXT:    movss %xmm0, (%esp)
; X86-NEXT:    flds (%esp)
; X86-NEXT:    popl %eax
; X86-NEXT:    retl
;
; X64-LABEL: i8_to_fp:
; X64:       ## %bb.0:
; X64-NEXT:    cvtsi2ss %edi, %xmm0
; X64-NEXT:    retq
  %2 = uitofp i8 %0 to float
  ret float %2
}
