/* CrackAgent.h
 *
 * Crack agent implementation
 *
 * Authors: Jiri Suchomel <jsuchome@suse.cz>
 *
 * $Id$
 */

#ifndef _CrackAgent_h
#define _CrackAgent_h

#include <Y2.h>
#include <scr/SCRAgent.h>

#include <crack.h>


/**
 * @short An interface class between YaST2 and Crack Agent
 */
class CrackAgent : public SCRAgent
{
private:
    /**
     * Agent private variables
     */
    string dictpath;
	
public:
    /**
     * Default constructor.
     */
    CrackAgent();

    /**
     * Destructor.
     */
    virtual ~CrackAgent();

    /**
     * Provides SCR Read ().
     * @param path Path that should be read.
     * @param arg Additional parameter.
     */
    virtual YCPValue Read(const YCPPath &path,
			  const YCPValue& arg = YCPNull(),
			  const YCPValue& opt = YCPNull());

    /**
     * Provides SCR Write ().
     */
    virtual YCPBoolean Write(const YCPPath &path,
			   const YCPValue& value,
			   const YCPValue& arg = YCPNull());

    /**
     * Provides SCR Execute ().
     */
    virtual YCPValue Execute(const YCPPath &path,
			     const YCPValue& value = YCPNull(),
			     const YCPValue& arg = YCPNull());

    /**
     * Provides SCR Dir ().
     */
    virtual YCPList Dir(const YCPPath& path);

    /**
     * Used for mounting the agent.
     */
    virtual YCPValue otherCommand(const YCPTerm& term);
};

#endif /* _CrackAgent_h */
