Migrating to version 1.0.0
==========================

Since version `1.0.0` we have updated the [`amqp`][amqp] dependency to version `1.0.3`.
This might require a couple of extra migration steps outlined below.

## Migration steps

### Disable `lager`

Some of the `amqp` [dependencies][lager_amqp] have started using `lager` as a logging framework. This will
result in the `lager` application being started in your elixir node and logging to certain files.

If you do not use `lager`, you can simply disable it by updating your application config:

~~~elixir
config :lager,
  crash_log: false,
  handlers: [level: :critical],
  error_logger_redirect: false,
  error_logger_whitelist: [Logger.ErrorHandler]
~~~

More information regarding lager and elixir support [here][lager_elixir].

### Solve `ranch` conflicts

If you are using `gen_rmq` in [`phoenix`][phoenix] application you might need to solve conflicting
[`ranch`][ranch] versions:

`phoenix 1.3.3` is using `ranch 1.3.2`

`gen_rmq 1.0.0` is using `ranch 1.5.0`

In order to solve the conflict, set `ranch` as a dependency in your `mix.exs` with `override: true` flag:

~~~elixir
{:ranch, "~> 1.5", override: true}
~~~

[amqp]: https://github.com/pma/amqp
[lager_amqp]: https://github.com/pma/amqp/wiki/Upgrade-from-0.X-to-1.0#lager
[lager_elixir]: https://github.com/erlang-lager/lager#elixir-support
[phoenix]: https://github.com/phoenixframework/phoenix
[ranch]: https://github.com/ninenines/ranch