defmodule Faker.Airports do
  import Faker, only: [sampler: 2, localize: 1]

  @moduledoc """
  Functions for generating airports related data
  """

  @doc """
  Returns a random ICAO

  ## Examples

      iex> Faker.Airports.icao()
      "SNOS"
      iex> Faker.Airports.icao()
      "UNBG"
      iex> Faker.Airports.icao()
      "KLOM"
      iex> Faker.Airports.icao()
      "HCME"
  """
  @spec icao() :: String.t()
  sampler(:icao, [
    "KMSY",
    "OIHR",
    "HTMA",
    "SSAQ",
    "GQPP",
    "KLBL",
    "VEBG",
    "SWII",
    "EVVA",
    "UHKM",
    "RPVD",
    "LSZL",
    "FTTY",
    "SNCP",
    "VOAT",
    "KBVU",
    "HEGR",
    "DIGL",
    "SNJB",
    "RORH",
    "FXMM",
    "DRRM",
    "YTMY",
    "ESNK",
    "WIDE",
    "HUTO",
    "VRMG",
    "SKPS",
    "NZRO",
    "AYWK",
    "LSGN",
    "VARG",
    "ULDD",
    "PAKY",
    "HUJI",
    "NZGM",
    "GVMT",
    "LIEE",
    "CYYG",
    "FALK",
    "VYHH",
    "USCC",
    "PABE",
    "SPHZ",
    "RKSW",
    "SPLN",
    "LGNX",
    "FMNC",
    "CYLC",
    "VNSK",
    "KEWN",
    "YGTE",
    "NVSZ",
    "LIBP",
    "YELD",
    "VNLK",
    "KAXA",
    "FNUE",
    "BITE",
    "LICJ",
    "YGIA",
    "OATN",
    "HANJ",
    "LFBP",
    "RPVM",
    "VOMM",
    "CYCO",
    "FKKD",
    "PFKK",
    "KBKL",
    "YHPN",
    "WMKM",
    "FMMH",
    "OIBL",
    "FMNL",
    "LEPA",
    "WBKN",
    "YMGT",
    "LHUD",
    "YBTL",
    "VCCW",
    "EGPD",
    "KDEC",
    "ENOL",
    "FASS",
    "FXTK",
    "RCQC",
    "SADL",
    "EBZR",
    "FLBA",
    "MMTN",
    "LFLM",
    "PGWT",
    "OPGT",
    "VNMA",
    "EDTD",
    "KGAB",
    "LFRB",
    "PAEH",
    "OIBJ",
    "UAAT",
    "BIBL",
    "OITK",
    "VIGG",
    "KTVC",
    "SGEN",
    "PTPN",
    "DAAZ",
    "LFKJ",
    "YTKY",
    "SNOS",
    "SETH",
    "MRNC",
    "SSLT",
    "VNDT",
    "SDKK",
    "PAYA",
    "ESUP",
    "EGHJ",
    "YRTP",
    "YRYH",
    "MMMX",
    "KBBG",
    "HABD",
    "FYOE",
    "TFFR",
    "EGET",
    "RKPC",
    "KBIS",
    "SEST",
    "SNGA",
    "CYOJ",
    "WIOG",
    "HEMA",
    "DXXX",
    "DRZA",
    "SBCN",
    "MMPA",
    "OINZ",
    "19AK",
    "ENAL",
    "SBBW",
    "VNDH",
    "LPSJ",
    "LLEY",
    "ZYTL",
    "HLLQ",
    "LPPS",
    "SATM",
    "ZSRG",
    "SKCL",
    "AGGH",
    "SUME",
    "SVCU",
    "USKK",
    "CYJT",
    "SUVO",
    "KPLN",
    "FAGI",
    "NGTU",
    "VVCM",
    "EPGL",
    "FQVL",
    "LELN",
    "PAOO",
    "LBIA",
    "ZYJM",
    "SMWS",
    "LLSD",
    "FVWT",
    "LHPR",
    "OMAA",
    "RPMF",
    "FCPA",
    "FAKZ",
    "FPPR",
    "UTAT",
    "YDBI",
    "CYEY",
    "KPWM",
    "EGJJ",
    "LFTW",
    "XBRO",
    "KEWK",
    "PAFA",
    "ZSGS",
    "CYQG",
    "WALJ",
    "SBLN",
    "FAAG",
    "LTCR",
    "VLOS",
    "LQTZ",
    "OPOR",
    "SVVP",
    "EGJB",
    "FMSF",
    "LTAN",
    "VLTK",
    "GMMB",
    "BGSS",
    "VVDH",
    "RCFG",
    "RJOM",
    "NTGU",
    "MMMD",
    "FMNQ",
    "GLGE",
    "ZWTN",
    "LIMW",
    "SUMO",
    "EGPI",
    "LFBT",
    "YBRU",
    "FZGV",
    "LRCS",
    "SAMM",
    "SAZC",
    "KPWT",
    "VTBK",
    "UELL",
    "EDAC",
    "SAOS",
    "SCBE",
    "UHBB",
    "LFBX",
    "FBSN",
    "KEND",
    "EGMC",
    "GBYD",
    "MNRT",
    "FIMP",
    "OIFS",
    "ZSGZ",
    "CYBQ",
    "KTMT",
    "SAWM",
    "NZGB",
    "KAHN",
    "CYGM",
    "USDS",
    "HUMA",
    "NZTG",
    "FYTM",
    "LFMH",
    "YSMR",
    "NVVI",
    "KHVR",
    "KDYL",
    "ENVD",
    "SNCE",
    "FBSP",
    "LYBE",
    "DFEL",
    "CYCS",
    "RJCO",
    "HCMA",
    "OPSK",
    "CKQ3",
    "YGBI",
    "YMMB",
    "CYYL",
    "SCGZ",
    "CYWK",
    "ZGSZ",
    "VYPU",
    "UNAA",
    "MMLC",
    "SNGI",
    "UKDD",
    "LELC",
    "AYNU",
    "SNLB",
    "SWTY",
    "SBFL",
    "KDVL",
    "ZPBS",
    "VIST",
    "HEOW",
    "HTSY",
    "OEWD",
    "LECO",
    "ZGBH",
    "LFSR",
    "SAOU",
    "CYMM",
    "EGFH",
    "SAZP",
    "YBRM",
    "FCOM",
    "PAHX",
    "SNJK",
    "SMST",
    "MYRP",
    "PHDH",
    "SLJE",
    "YTAA",
    "EDLM",
    "NWWO",
    "WPMN",
    "AYML",
    "FQBR",
    "CYZE",
    "OMFJ",
    "HCME",
    "KLBE",
    "UIAA",
    "KLFT",
    "AYOG",
    "HTTG",
    "LFMR",
    "FZRB",
    "CYID",
    "ENHK",
    "AYLU",
    "CYDM",
    "WIBT",
    "PTYA",
    "KBNL",
    "SVPE",
    "YGDI",
    "VTSR",
    "SCSE",
    "HSKI",
    "SYOR",
    "RJSN",
    "HSSM",
    "DTKA",
    "HKMB",
    "LBBG",
    "VOTV",
    "AYMC",
    "TFFJ",
    "ZGHY",
    "HSPN",
    "KMOT",
    "LTAW",
    "LUKK",
    "UUYH",
    "YSGT",
    "OITT",
    "OIBI",
    "KBYS",
    "OPDI",
    "OYHD",
    "EGDL",
    "FOOH",
    "LIQN",
    "KTEX",
    "OPFA",
    "FZAM",
    "HBBO",
    "OAHR",
    "LIRH",
    "ZBCF",
    "LPLA",
    "CYNL",
    "SAEM",
    "EFMI",
    "WATT",
    "SADP",
    "AGGS",
    "KARR",
    "VTSP",
    "MGTK",
    "FCBS",
    "LGKL",
    "FAUT",
    "FASZ",
    "YLHR",
    "ZGMX",
    "MBNC",
    "SNMB",
    "ESPA",
    "FMNV",
    "UKLL",
    "TFFB",
    "YSPK",
    "SBCF",
    "UKDE",
    "AYMH",
    "GAKO",
    "WMKA",
    "SWBR",
    "KAIA",
    "LIBR",
    "LTFD",
    "ZPPP",
    "SMCA",
    "MMIA",
    "YLEC",
    "RPMJ",
    "FEFI",
    "DNAA",
    "PAFV",
    "ENKR",
    "YFST",
    "FMCZ",
    "NGKT",
    "FAKP",
    "NFNA",
    "UNBG",
    "KJST",
    "CYSN",
    "UNKL",
    "SWTS",
    "HUKS",
    "MMPE",
    "ESGT",
    "RPLC",
    "ESSD",
    "WAMJ",
    "VVVH",
    "WMKP",
    "HESC",
    "DFEE",
    "SWNS",
    "SVON",
    "MHCA",
    "KALS",
    "GQNT",
    "DBBK",
    "LFRK",
    "YPMP",
    "YCCT",
    "UKKG",
    "EDVE",
    "CYRQ",
    "KGLS",
    "CYXP",
    "CYPQ",
    "PHSF",
    "KDRT",
    "SWSI",
    "KPBI",
    "UMMG",
    "HKGA",
    "DIBK",
    "PAMY",
    "ZYJZ",
    "BIRF",
    "YGTN",
    "LBWN",
    "EFET",
    "OLKA",
    "NTGQ",
    "EDDL",
    "HCMK",
    "VTSS",
    "SARS",
    "SPHI",
    "YORB",
    "YLEO",
    "USNN",
    "SEMA",
    "LKZA",
    "EKEB",
    "DISP",
    "NTGV",
    "RJKA",
    "VVCI",
    "SPAO",
    "EFKS",
    "CYHK",
    "SKIG",
    "SKTL",
    "ENDU",
    "UWSS",
    "EILT",
    "SEAM",
    "LSZS",
    "YMTG",
    "YCHK",
    "OPCL",
    "SYKM",
    "SVPM",
    "CYFT",
    "KTUL",
    "HSHG",
    "FOGI",
    "KLYH",
    "LGKV",
    "PASX",
    "YRSB",
    "SEMH",
    "CYCB",
    "LDOS",
    "DFOU",
    "GUNZ",
    "FASB",
    "KRXE",
    "VNSR",
    "EDDP",
    "GQNA",
    "ORBI",
    "VTCT",
    "MUCF",
    "SWMW",
    "PAKP",
    "KMKL",
    "KMEM",
    "WMKD",
    "FXMF",
    "LIML",
    "UJAP",
    "LILQ",
    "YOEN",
    "SNNU",
    "KDYS",
    "SBVG",
    "LYTV",
    "RPMG",
    "KEUG",
    "PAWI",
    "LTAF",
    "YLOV",
    "MDPC",
    "UNKY",
    "FMSC",
    "HALL",
    "FACD",
    "ZLLL",
    "WADS",
    "RCKH",
    "YERN",
    "OPBN",
    "KO43",
    "SNGJ",
    "NZKE",
    "LGKO",
    "EGPR",
    "NZTK",
    "KLIT",
    "VIJR",
    "SBCZ",
    "KDAA",
    "MMTP",
    "SBBG",
    "SKAM",
    "WAMH",
    "LSZB",
    "CYHM",
    "TVSV",
    "VHHH",
    "KCCB",
    "MUMJ",
    "SWKO",
    "ZHNY",
    "MMTG",
    "GLTN",
    "OSLK",
    "FAVR",
    "KALW",
    "PAWS",
    "SEGU",
    "FXNK",
    "YSHK",
    "NZRA",
    "RKJJ",
    "SLCA",
    "YKMP",
    "ZMBN",
    "KDTW",
    "UTNU",
    "YVRD",
    "KACK",
    "PASH",
    "HLLM",
    "RKNY",
    "SDRS",
    "KBFI",
    "EDTL",
    "MHBL",
    "CYQB",
    "EHTW",
    "HLLB",
    "AYBU",
    "WBGQ",
    "LFCK",
    "LFRJ",
    "CZBD",
    "EFOU",
    "WBKP",
    "ZUTC",
    "SAZY",
    "UARR",
    "NFFA",
    "TNCS",
    "SBTR",
    "KCMI",
    "CYQK",
    "PFNO",
    "KLAX",
    "KGSO",
    "GOTT",
    "ORBM",
    "AYFI",
    "YARA",
    "HESX",
    "SKFL",
    "UWLL",
    "MMLM",
    "ZSYW",
    "MBGT",
    "CYCZ",
    "KABY",
    "BGGH",
    "LIPB",
    "LFCE",
    "AYSE",
    "AYTI",
    "ENNA",
    "LEMD",
    "LELO",
    "SBCA",
    "SNBU",
    "WITM",
    "CYER",
    "LFMO",
    "YNRC",
    "FEFS",
    "MTPP",
    "KSLK",
    "SVSA",
    "LCPH",
    "YDPD",
    "SKEJ",
    "WMKE",
    "ENEV",
    "MBMC",
    "CYKA",
    "EGPU",
    "KDEH",
    "LFLS",
    "FXSK",
    "EBBR",
    "SPAY",
    "OISS",
    "KE13",
    "LIDT",
    "KSDF",
    "PHNY",
    "SBIZ",
    "CYIF",
    "NFTE",
    "SAVJ",
    "SNMU",
    "SBLJ",
    "MRDK",
    "LLBS",
    "KABR",
    "FKKW",
    "ZSSS",
    "DRZR",
    "HESN",
    "OPLA",
    "DNCA",
    "LFBH",
    "SNJN",
    "LPBJ",
    "SACO",
    "YDDF",
    "KCSG",
    "OEPS",
    "SBKG",
    "KAUN",
    "EDFE",
    "VLPS",
    "YSNB",
    "VVPR",
    "GMFO",
    "WIOK",
    "SBHT",
    "EBKT",
    "HEBL",
    "SKCN",
    "LIMJ",
    "WBKM",
    "EFLA",
    "KRUT",
    "DNKA",
    "ZMMN",
    "VYNS",
    "YDLK",
    "PAUM",
    "ZLZW",
    "MMLO",
    "WATM",
    "URMO",
    "KSFO",
    "VEDZ",
    "ZYAS",
    "SNVB",
    "FATH",
    "LPPI",
    "HCMD",
    "WRLB",
    "LFOB",
    "UUEE",
    "AGGN",
    "LTFC",
    "ZSLQ",
    "LFRT",
    "ZSBB",
    "ZMUL",
    "CNM5",
    "UNWW",
    "KHXD",
    "FAGM",
    "LGKJ",
    "ROMY",
    "YDBY",
    "OERK",
    "FZFP",
    "SDNH",
    "FADQ",
    "SGCO",
    "CAL4",
    "SUCM",
    "TNCC",
    "OPTA",
    "WMBA",
    "SOOM",
    "DAOO",
    "OAMN",
    "EIIM",
    "UUYY",
    "OPGD",
    "KSHD",
    "LTAQ",
    "KBNO",
    "KINT",
    "NCMR",
    "LTFE",
    "ZLXY",
    "GQNS",
    "GMMN",
    "FCOS",
    "OPTH",
    "CYRT",
    "YBOK",
    "FAMD",
    "CZEM",
    "SGAY",
    "ROYN",
    "CYSJ",
    "CCK4",
    "ENKB",
    "LFKC",
    "KIYK",
    "ZYTN",
    "FMMS",
    "ZGHZ",
    "EFHV",
    "PACM",
    "HTMI",
    "VLSV",
    "WAWW",
    "LLMZ",
    "NSFI",
    "KBUB",
    "NWWU",
    "EGPO",
    "NVVQ",
    "NWWM",
    "SKAD",
    "SDBY",
    "ULKK",
    "KAIK",
    "NTTP",
    "PACZ",
    "MYAW",
    "OPTT",
    "AYBA",
    "EYKA",
    "GOBD",
    "FCBB",
    "ENGM",
    "EBLG",
    "SACC",
    "YCNM",
    "KADW",
    "RPVE",
    "RPVA",
    "ETNG",
    "SAZG",
    "GQNI",
    "VYSW",
    "MRCA",
    "LFLL",
    "CYFR",
    "GMMZ",
    "ETSI",
    "VIBN",
    "YPIR",
    "KORF",
    "OIAM",
    "BGAA",
    "HLZW",
    "VAKS",
    "UTNN",
    "SCTN",
    "KADS",
    "HCMU",
    "HAKL",
    "SVSR",
    "MMBT",
    "ENLK",
    "DATM",
    "VNRT",
    "LFGW",
    "SBUG",
    "SAWT",
    "SKNQ",
    "ZSSH",
    "AYKB",
    "HKWJ",
    "SBTG",
    "EGQS",
    "LIPT",
    "YSMP",
    "SATU",
    "CYWY",
    "SAVB",
    "SNTK",
    "MUBY",
    "SWCW",
    "WALV",
    "URFB",
    "NTGT",
    "VEMH",
    "YKBR",
    "CYND",
    "OIBB",
    "SKAP",
    "KLOM",
    "SBCO",
    "YSWG",
    "USRR",
    "RJTT",
    "LTBE",
    "WAKP",
    "KSPI",
    "EGXU",
    "LEJR",
    "KGCN",
    "CYPE",
    "YPXM",
    "YFNE",
    "VLSB",
    "CYGT",
    "MTJA",
    "OODQ",
    "SSGY",
    "GQNE",
    "WIOM",
    "YMUG",
    "USTO",
    "YGLG",
    "NSMA",
    "KIGM",
    "MYCC",
    "SYMB",
    "LFOO",
    "KGTR",
    "AYAT",
    "LFMI",
    "DTTJ",
    "EDGS",
    "YEIN",
    "EPPO",
    "SBQV",
    "KIPT",
    "UAFO",
    "UBBN",
    "KGFK",
    "KAMW",
    "KMHK",
    "SNBR",
    "EGDY",
    "EGGP",
    "ZBUL",
    "LIRF",
    "VYMK",
    "CDK2",
    "SKAN",
    "GASK",
    "UHOO",
    "URRP",
    "FZIR",
    "MMDA",
    "KPHH",
    "K0B8",
    "GMAZ",
    "SBGU",
    "LSZM",
    "LYVA",
    "RPLU",
    "VYLS",
    "ZYTX",
    "PAKU",
    "UAOO",
    "FCPD",
    "SAVS",
    "DBBN",
    "YMLT",
    "HSNN",
    "NCMH",
    "ZLSN",
    "DAAT",
    "AYGG",
    "EHBK",
    "3IS8",
    "SCFT",
    "OPNK",
    "HEPS",
    "SDJC",
    "MBSY",
    "OPCH",
    "GCXO",
    "FZUG",
    "UMMS",
    "YBNA",
    "FLCP",
    "KVCT",
    "NZTS",
    "FBJW",
    "ZLDH",
    "LIER",
    "SBPL",
    "SOOR",
    "KICT",
    "FKKR",
    "CYEV",
    "CYHO",
    "KDGW",
    "VGSY",
    "DIDL",
    "KAMN",
    "PAFE",
    "SKBU",
    "ROIG",
    "CYLU",
    "KBNA",
    "VTED",
    "VVDN",
    "NZWK",
    "SYKR",
    "SGES",
    "OITM",
    "YBIL",
    "PATG",
    "LFPO",
    "LFBG",
    "UATT",
    "FAMH",
    "EDXO",
    "SDTO",
    "DAUI",
    "KVLD",
    "ZSJJ",
    "BISI",
    "VVCS",
    "FKKB",
    "YMWA",
    "KBBD",
    "KPIH",
    "LFLU",
    "CYBL",
    "LTBS",
    "KOAK",
    "RPMV",
    "KJMS",
    "RJOT",
    "CTU5",
    "NIUE",
    "HKKG",
    "VARK",
    "SPJJ",
    "KBPT",
    "SKTA",
    "RPMM",
    "EPBK",
    "YPAM",
    "FZQA",
    "YMJM",
    "YMEN",
    "SBMC",
    "CYXC",
    "WICT",
    "CYFC",
    "AGGY",
    "VYPT",
    "SKMR",
    "ZMBR",
    "AGOK",
    "KGYY",
    "FZRQ",
    "EGQB",
    "YBLA"
  ])

  @doc """
  Returns a random IATA

  ## Examples

      iex> Faker.Airports.iata()
      "BFU"
      iex> Faker.Airports.iata()
      "FMM"
      iex> Faker.Airports.iata()
      "YUS"
      iex> Faker.Airports.iata()
      "YPH"
  """
  @spec iata() :: String.t()
  sampler(:iata, [
    "MKE",
    "CBY",
    "PDX",
    "THQ",
    "DRT",
    "HDF",
    "CAX",
    "YQS",
    "ERZ",
    "EYR",
    "MOM",
    "ACN",
    "AKL",
    "CVT",
    "BGA",
    "AGS",
    "KSO",
    "MQA",
    "FIH",
    "USI",
    "GBK",
    "NON",
    "BNJ",
    "DUD",
    "SHO",
    "STB",
    "ANI",
    "AFT",
    "WBD",
    "MJF",
    "PSD",
    "BXT",
    "PZY",
    "WEF",
    "DPE",
    "ZAC",
    "KNG",
    "KVX",
    "IXN",
    "CAF",
    "PBQ",
    "KBV",
    "CCJ",
    "GNN",
    "VRL",
    "DBD",
    "XAP",
    "URY",
    "RJK",
    "OKH",
    "ATY",
    "SAZ",
    "LNX",
    "YRG",
    "NYN",
    "YEY",
    "HGU",
    "DYA",
    "OAZ",
    "AUO",
    "HVD",
    "LSA",
    "RTM",
    "ODB",
    "VCP",
    "IGO",
    "ILP",
    "TRC",
    "YQC",
    "BWM",
    "USM",
    "NHS",
    "ANX",
    "SLA",
    "SZS",
    "ORK",
    "NJC",
    "HRS",
    "MEN",
    "KSK",
    "YOJ",
    "SQX",
    "GRR",
    "CHO",
    "MEH",
    "ILI",
    "WBQ",
    "BGN",
    "IPL",
    "YWP",
    "YGK",
    "NCR",
    "ZAR",
    "OVL",
    "CSB",
    "IIL",
    "ZAG",
    "BIS",
    "MYR",
    "DHT",
    "USK",
    "BDS",
    "YVP",
    "YKA",
    "ZYL",
    "WTN",
    "LTN",
    "RVV",
    "BOZ",
    "UTW",
    "BFU",
    "BYK",
    "AHE",
    "KCA",
    "AQJ",
    "YGV",
    "YSM",
    "AGU",
    "ALB",
    "SEW",
    "BME",
    "VOT",
    "TCP",
    "CKY",
    "BSJ",
    "XCH",
    "KUH",
    "LVB",
    "WYA",
    "JUT",
    "SCC",
    "NAT",
    "LEF",
    "GIU",
    "EHM",
    "ASH",
    "TJH",
    "LRD",
    "DOM",
    "SDY",
    "SHW",
    "GRW",
    "VLC",
    "VOH",
    "HKK",
    "TUF",
    "CEK",
    "XYA",
    "TCX",
    "ZHA",
    "YKL",
    "ZWA",
    "GES",
    "RMQ",
    "BTM",
    "PQC",
    "YVM",
    "BVR",
    "IVR",
    "OAR",
    "GON",
    "KNI",
    "APC",
    "RIG",
    "PQE",
    "OKD",
    "QCR",
    "MDH",
    "JMO",
    "SKX",
    "ODA",
    "TUB",
    "DLX",
    "ADA",
    "VYD",
    "IIA",
    "PBU",
    "WMN",
    "SMW",
    "SJC",
    "PPW",
    "QYY",
    "FAU",
    "VHC",
    "BRL",
    "OOR",
    "ADT",
    "VLV",
    "MAK",
    "ANU",
    "NDM",
    "MDP",
    "KHE",
    "CNB",
    "VPY",
    "URT",
    "KEV",
    "ZOJ",
    "GMA",
    "BSY",
    "TOM",
    "FLZ",
    "COS",
    "UPG",
    "BLB",
    "ALN",
    "VSG",
    "MMJ",
    "PTK",
    "BEH",
    "GGW",
    "RHG",
    "YWJ",
    "BEQ",
    "MSL",
    "VTL",
    "YHT",
    "DDC",
    "POZ",
    "CBM",
    "JLN",
    "ODJ",
    "NOR",
    "VDE",
    "BCO",
    "QHR",
    "RBO",
    "TNR",
    "QOB",
    "KWL",
    "KOS",
    "CYI",
    "NWI",
    "TIU",
    "YQL",
    "PDZ",
    "CRF",
    "OSZ",
    "MEK",
    "LAI",
    "VIN",
    "CMN",
    "YRL",
    "QOJ",
    "FRD",
    "SYM",
    "JNG",
    "TOX",
    "CAU",
    "BYW",
    "ODR",
    "JSY",
    "GWY",
    "ZKM",
    "BXD",
    "SUV",
    "YSH",
    "HGR",
    "CKW",
    "PEL",
    "CDY",
    "OWB",
    "PNR",
    "MOU",
    "YWA",
    "TGU",
    "SFC",
    "FRF",
    "LPA",
    "GGS",
    "ADC",
    "SPJ",
    "YXE",
    "SZV",
    "CYB",
    "IRI",
    "TFM",
    "PZA",
    "SFG",
    "ALQ",
    "MWZ",
    "MQT",
    "CIW",
    "VLG",
    "YGB",
    "PBB",
    "HTU",
    "ICT",
    "CUO",
    "NEG",
    "YUB",
    "ASO",
    "YBC",
    "ORX",
    "NZE",
    "DJA",
    "EIH",
    "GOJ",
    "SUH",
    "EGH",
    "GOQ",
    "OHE",
    "HFA",
    "ISB",
    "YPH",
    "BNS",
    "PCP",
    "MQL",
    "LBD",
    "YAA",
    "ZBY",
    "SUJ",
    "PUX",
    "YKQ",
    "YCD",
    "KEQ",
    "LKY",
    "SSG",
    "BVH",
    "CBW",
    "PSO",
    "GAY",
    "KOP",
    "LSZ",
    "SUF",
    "WLA",
    "HTZ",
    "BGW",
    "TCU",
    nil,
    "PZO",
    "MDI",
    "BRU",
    "XAB",
    "AIK",
    "FGU",
    "YKU",
    "KIJ",
    "YOL",
    "DXB",
    "KBR",
    "RTS",
    "MRU",
    "WGT",
    "YSL",
    "LSM",
    "AYK",
    "CIQ",
    "CGH",
    "LKH",
    "SZX",
    "LMO",
    "FSI",
    "PER",
    "ISP",
    "BMK",
    "MQK",
    "OSY",
    "PFN",
    "MVP",
    "EDM",
    "ASC",
    "SIA",
    "KWE",
    "GAW",
    "FDH",
    "KEE",
    "RCO",
    "TYP",
    "XML",
    "ILF",
    "SAQ",
    "OIM",
    "ABX",
    "IWO",
    "LSI",
    "BMY",
    "ESU",
    "FVL",
    "YKS",
    "HLH",
    "STM",
    "YCR",
    "PAK",
    "PMF",
    "BHW",
    "PPR",
    "YMJ",
    "SAL",
    "ARD",
    "AOR",
    "BSF",
    "TJQ",
    "TIQ",
    "MCI",
    "CHM",
    "TIN",
    "PIA",
    "LDI",
    "ZBF",
    "LAS",
    "FMM",
    "GHB",
    "QPG",
    "UDJ",
    "NAE",
    "LOD",
    "ACJ",
    "PXO",
    "XKH",
    "YYL",
    "EBS",
    "PLD",
    "KRT",
    "EUC",
    "IKP",
    "LUW",
    "BCT",
    "LGL",
    "YHI",
    "YZY",
    "MCX",
    "BEG",
    "LBO",
    "MDZ",
    "YMT",
    "BOB",
    "YXJ",
    "URC",
    "RRS",
    "SDH",
    "BUI",
    "NML",
    "MXD",
    "BBS",
    "XMY",
    "EBB",
    "ORE",
    "DGF",
    "DPS",
    "KSE",
    "UEL",
    "GVN",
    "GTI",
    "INO",
    "DAN",
    "GRQ",
    "WIK",
    "ONR",
    "ADG",
    "CMA",
    "AQI",
    "HNL",
    "BTH",
    "WDH",
    "TEC",
    "MST",
    "TNI",
    "CSY",
    "SBG",
    "SKH",
    "KUD",
    "EFL",
    "TAN",
    "JCB",
    "WHK",
    "SHB",
    "GPI",
    "PGZ",
    "YLK",
    "CLJ",
    "ELH",
    "TAW",
    "URA",
    "OSK",
    "WLC",
    "TWB",
    "WTP",
    "KGD",
    "KSM",
    "YMM",
    "UBJ",
    "VLI",
    "WKR",
    "SLJ",
    "FEK",
    "MEA",
    "SRZ",
    "OAG",
    "IXL",
    "HLS",
    "ELO",
    "BGB",
    "BLK",
    "LZR",
    "AYO",
    "POM",
    "MAL",
    "KAA",
    "GVI",
    "RDS",
    "TKQ",
    "EWI",
    "OZZ",
    "PMS",
    "ATZ",
    "BIG",
    "HOK",
    "CEN",
    "NLS",
    "BFP",
    "BWI",
    "DAD",
    "PIZ",
    "OKI",
    "MAZ",
    "TUQ",
    "CBF",
    "XVN",
    "DQH",
    "YSB",
    "OXP",
    "DGW",
    "INJ",
    "TCZ",
    "MBC",
    "IDR",
    "SKV",
    "YHK",
    "MSO",
    "BXO",
    "CFO",
    "CCM",
    "YYJ",
    "AAU",
    "FKQ",
    "DRS",
    "IXQ",
    "MVD",
    "HTG",
    "SVO",
    "YNC",
    "ASY",
    "XAC",
    "KKW",
    "ADF",
    "KGE",
    "BMP",
    "TIP",
    "OBN",
    "UBP",
    "ERF",
    "OSW",
    "ING",
    "PDC",
    "FLI",
    "OEC",
    "ONU",
    "MFC",
    "SID",
    "MMP",
    "NEL",
    "AUT",
    "VNO",
    "UUK",
    "HYA",
    "TUC",
    "UMR",
    "YRB",
    "AEP",
    "PSL",
    "UUD",
    "TEZ",
    "GRI",
    "BZI",
    "VCT",
    "MZR",
    "CZE",
    "COK",
    "SPX",
    "PTJ",
    "NGE",
    "NTX",
    "YHU",
    "LYS",
    "XSE",
    "OKQ",
    "DLU",
    "DAX",
    "ARC",
    "EOH",
    "OLC",
    "LRU",
    "MBH",
    "KOE",
    "JAM",
    "DDU",
    "DMK",
    "CIY",
    "EDL",
    "TKG",
    "AFF",
    "SQM",
    "YXK",
    "SGV",
    "SNF",
    "MHO",
    "ACB",
    "TDT",
    "KST",
    "AAN",
    "SOM",
    "CBH",
    "VRB",
    "VUS",
    "ISK",
    "SLS",
    "JAF",
    "TTJ",
    "MNQ",
    "LPY",
    "OCJ",
    "ABA",
    "FMU",
    "SXI",
    "KAD",
    "FAI",
    "YOT",
    "VEV",
    "KAY",
    "GUW",
    "YQU",
    "GVR",
    "KMK",
    "LOA",
    "SOJ",
    "BCN",
    "COV",
    "LAP",
    "HDR",
    "FLN",
    "BTW",
    "YVT",
    "ORP",
    "TRR",
    "MZH",
    "RUY",
    "SDT",
    "MMY",
    "ORF",
    "CAL",
    "RKA",
    "VDA",
    "YAI",
    "KSA",
    "ATS",
    "GIC",
    "YTL",
    "YGJ",
    "RHL",
    "QUG",
    "GDE",
    "MYG",
    "WTA",
    "YFS",
    "TME",
    "GLX",
    "CVN",
    "RIM",
    "LAJ",
    "SMG",
    "ANC",
    "EVV",
    "APL",
    "TID",
    "USN",
    "KRG",
    "EIN",
    "OTR",
    "SDE",
    "ARZ",
    "MKL",
    "SVD",
    "GEA",
    "YWM",
    "LOH",
    "SGS",
    "TRG",
    "BZN",
    "ELM",
    "NAL",
    "CIM",
    "KUN",
    "LSQ",
    "CDF",
    "CGV",
    "ZSA",
    "MXJ",
    "RCB",
    "LFB",
    "QDB",
    "AJY",
    "SBI",
    "DTL",
    "WHU",
    "RUH",
    "AVP",
    "GPA",
    "CIA",
    "GAQ",
    "QIG",
    "SWA",
    "IOA",
    "JFR",
    "INV",
    "AZO",
    "EDI",
    "BLP",
    "EEN",
    "BIH",
    "CUV",
    "RRR",
    "MXX",
    "VVK",
    "RSU",
    "IXV",
    "CML",
    "MMD",
    "HDH",
    "LAF",
    "RNS",
    "MOJ",
    "XGG",
    "LVR",
    "ICK",
    "PIP",
    "TYM",
    "SYU",
    "OTM",
    "TER",
    "LBY",
    "APT",
    "TCH",
    "LLA",
    "ANN",
    "TVA",
    "ZBE",
    "MFF",
    "TUU",
    "CNN",
    "SGX",
    "APB",
    "ERA",
    "ZNE",
    "SHH",
    "FSP",
    "VAD",
    "RSA",
    "ESD",
    "LGS",
    "ZAJ",
    "KBZ",
    "PES",
    "OFU",
    "EPR",
    "GJA",
    "SXS",
    "MIU",
    "CPO",
    "BOJ",
    "KUV",
    "WAC",
    "YHD",
    "MSA",
    "YAW",
    "ULU",
    "TAZ",
    "HUF",
    "LCV",
    "KKZ",
    "ZRJ",
    "VKX",
    "WBO",
    "OME",
    "CAS",
    "IEV",
    "CBP",
    "UPV",
    "SIO",
    "KFA",
    "UKA",
    "AAM",
    "FRW",
    "DUE",
    "YST",
    "OKT",
    "MDX",
    "BRQ",
    "VOZ",
    "AUA",
    "IVC",
    "BVZ",
    "YPA",
    "DTR",
    "GNS",
    "QVE",
    "OSR",
    "MXN",
    "BLV",
    "LCG",
    "CKZ",
    "TCB",
    "ZST",
    "AYQ",
    "MGQ",
    "KCZ",
    "JEE",
    "GAG",
    "TVU",
    "BWE",
    "DZN",
    "XDE",
    "LEQ",
    "GYN",
    "VVC",
    "DSS",
    "AAZ",
    "IGM",
    "KGL",
    "JIW",
    "BYF",
    "MOT",
    "WSR",
    "AIF",
    "ELF",
    "YUS",
    "MDT",
    "LBJ",
    "FNE",
    "YAZ",
    "NTQ",
    "LUQ",
    "LBE",
    "GOT",
    "DBB",
    "AIT",
    "PSW",
    "CHB",
    "FXO",
    "LUD",
    "TBP",
    "CRV",
    "WLS",
    "JHM",
    "WXN",
    "MQE",
    "DAM",
    "BCB",
    "NCL",
    "YQT",
    "APH",
    "BZY",
    "BJV",
    "REA",
    "GTF",
    "ACE",
    "VVO",
    "FEL",
    "VNE",
    "KRK",
    "NWA",
    "MKZ",
    "HTY",
    "CWE",
    "QIQ",
    "TNH",
    "KSW",
    "CZX",
    "UBR",
    "KTR",
    "STZ",
    "XTR",
    "AUX",
    "MGM",
    "MGT",
    "ULX",
    "SFO",
    "WTD",
    "DOK",
    "DNB",
    "KJK",
    "ZEM",
    "GRJ",
    "CJA",
    "IAH",
    "BIE",
    "VHZ",
    "KAC",
    "RAH",
    "ATP",
    "GFN",
    "ARG",
    "RGO",
    "OKA",
    "URO",
    "CEB",
    "KQT",
    "LLW",
    "YFE",
    "YAS",
    "TRS",
    "PSA",
    "FTI",
    "MFN",
    "GVA",
    "CTU",
    "YWK",
    "QJB",
    "KIX",
    "WIO",
    "BKM",
    "PNH",
    "SZB",
    "NOJ",
    "AOC",
    "ADU",
    "ABF",
    "RBV",
    "PRA",
    "NNX",
    "NAV",
    "POX",
    "EKO",
    "NTE",
    "TUN",
    "UEE",
    "SZG",
    "RDG",
    "JMK",
    "CKB",
    "CEX",
    "FOT",
    "WAT",
    "VIC",
    "MTQ",
    "BOO",
    "HBU",
    "MOI",
    "NDJ",
    "GUL",
    "CGR",
    "UIR",
    "JAL",
    "GUX",
    "HNH",
    "LTK",
    "UNK",
    "ZUH",
    "LUG",
    "WSG",
    "OCC",
    "VGO",
    "YPN",
    "IVW",
    "TQL",
    "NUU",
    "EBM",
    "HYS",
    "BUQ",
    "YDN",
    "CRK",
    "GUJ",
    "YMS",
    "YMG",
    "ZCN",
    "YUM",
    "GUB",
    "URM",
    "MRO",
    "BEO",
    "TEY",
    "YPR",
    "AMC",
    "SIL",
    "IRO",
    "QLS",
    "QZO",
    "MQD",
    "NPL",
    "DEM",
    "OHT",
    "OSO",
    "SKD",
    "HWN",
    "NCE",
    "ZND",
    "GAN",
    "CGD",
    "ZPQ",
    "LED"
  ])

  @spec name() :: String.t()
  localize(:name)
end
