// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// PatchLibraryElementCommand PatchLibraryElementCommand is the command for patching a LibraryElement
//
// swagger:model PatchLibraryElementCommand
type PatchLibraryElementCommand struct {

	// ID of the folder where the library element is stored.
	FolderID int64 `json:"folderId,omitempty"`

	// UID of the folder where the library element is stored.
	FolderUID string `json:"folderUid,omitempty"`

	// Kind of element to create, Use 1 for library panels or 2 for c.
	// Description:
	// 1 - library panels
	// 2 - library variables
	// Enum: [1 2]
	Kind int64 `json:"kind,omitempty"`

	// The JSON model for the library element.
	Model interface{} `json:"model,omitempty"`

	// Name of the library element.
	Name string `json:"name,omitempty"`

	// uid
	UID string `json:"uid,omitempty"`

	// Version of the library element you are updating.
	Version int64 `json:"version,omitempty"`
}

// Validate validates this patch library element command
func (m *PatchLibraryElementCommand) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateKind(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var patchLibraryElementCommandTypeKindPropEnum []interface{}

func init() {
	var res []int64
	if err := json.Unmarshal([]byte(`[1,2]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		patchLibraryElementCommandTypeKindPropEnum = append(patchLibraryElementCommandTypeKindPropEnum, v)
	}
}

// prop value enum
func (m *PatchLibraryElementCommand) validateKindEnum(path, location string, value int64) error {
	if err := validate.EnumCase(path, location, value, patchLibraryElementCommandTypeKindPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PatchLibraryElementCommand) validateKind(formats strfmt.Registry) error {
	if swag.IsZero(m.Kind) { // not required
		return nil
	}

	// value enum
	if err := m.validateKindEnum("kind", "body", m.Kind); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this patch library element command based on context it is used
func (m *PatchLibraryElementCommand) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *PatchLibraryElementCommand) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PatchLibraryElementCommand) UnmarshalBinary(b []byte) error {
	var res PatchLibraryElementCommand
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
