// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetAlertRulesExportParams creates a new GetAlertRulesExportParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetAlertRulesExportParams() *GetAlertRulesExportParams {
	return &GetAlertRulesExportParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetAlertRulesExportParamsWithTimeout creates a new GetAlertRulesExportParams object
// with the ability to set a timeout on a request.
func NewGetAlertRulesExportParamsWithTimeout(timeout time.Duration) *GetAlertRulesExportParams {
	return &GetAlertRulesExportParams{
		timeout: timeout,
	}
}

// NewGetAlertRulesExportParamsWithContext creates a new GetAlertRulesExportParams object
// with the ability to set a context for a request.
func NewGetAlertRulesExportParamsWithContext(ctx context.Context) *GetAlertRulesExportParams {
	return &GetAlertRulesExportParams{
		Context: ctx,
	}
}

// NewGetAlertRulesExportParamsWithHTTPClient creates a new GetAlertRulesExportParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetAlertRulesExportParamsWithHTTPClient(client *http.Client) *GetAlertRulesExportParams {
	return &GetAlertRulesExportParams{
		HTTPClient: client,
	}
}

/*
GetAlertRulesExportParams contains all the parameters to send to the API endpoint

	for the get alert rules export operation.

	Typically these are written to a http.Request.
*/
type GetAlertRulesExportParams struct {

	/* Download.

	   Whether to initiate a download of the file or not.
	*/
	Download *bool

	/* FolderUID.

	   UIDs of folders from which to export rules
	*/
	FolderUID []string

	/* Format.

	   Format of the downloaded file, either yaml or json. Accept header can also be used, but the query parameter will take precedence.

	   Default: "yaml"
	*/
	Format *string

	/* Group.

	   Name of group of rules to export. Must be specified only together with a single folder UID
	*/
	Group *string

	/* RuleUID.

	   UID of alert rule to export. If specified, parameters folderUid and group must be empty.
	*/
	RuleUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get alert rules export params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetAlertRulesExportParams) WithDefaults() *GetAlertRulesExportParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get alert rules export params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetAlertRulesExportParams) SetDefaults() {
	var (
		downloadDefault = bool(false)

		formatDefault = string("yaml")
	)

	val := GetAlertRulesExportParams{
		Download: &downloadDefault,
		Format:   &formatDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the get alert rules export params
func (o *GetAlertRulesExportParams) WithTimeout(timeout time.Duration) *GetAlertRulesExportParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get alert rules export params
func (o *GetAlertRulesExportParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get alert rules export params
func (o *GetAlertRulesExportParams) WithContext(ctx context.Context) *GetAlertRulesExportParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get alert rules export params
func (o *GetAlertRulesExportParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get alert rules export params
func (o *GetAlertRulesExportParams) WithHTTPClient(client *http.Client) *GetAlertRulesExportParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get alert rules export params
func (o *GetAlertRulesExportParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDownload adds the download to the get alert rules export params
func (o *GetAlertRulesExportParams) WithDownload(download *bool) *GetAlertRulesExportParams {
	o.SetDownload(download)
	return o
}

// SetDownload adds the download to the get alert rules export params
func (o *GetAlertRulesExportParams) SetDownload(download *bool) {
	o.Download = download
}

// WithFolderUID adds the folderUID to the get alert rules export params
func (o *GetAlertRulesExportParams) WithFolderUID(folderUID []string) *GetAlertRulesExportParams {
	o.SetFolderUID(folderUID)
	return o
}

// SetFolderUID adds the folderUid to the get alert rules export params
func (o *GetAlertRulesExportParams) SetFolderUID(folderUID []string) {
	o.FolderUID = folderUID
}

// WithFormat adds the format to the get alert rules export params
func (o *GetAlertRulesExportParams) WithFormat(format *string) *GetAlertRulesExportParams {
	o.SetFormat(format)
	return o
}

// SetFormat adds the format to the get alert rules export params
func (o *GetAlertRulesExportParams) SetFormat(format *string) {
	o.Format = format
}

// WithGroup adds the group to the get alert rules export params
func (o *GetAlertRulesExportParams) WithGroup(group *string) *GetAlertRulesExportParams {
	o.SetGroup(group)
	return o
}

// SetGroup adds the group to the get alert rules export params
func (o *GetAlertRulesExportParams) SetGroup(group *string) {
	o.Group = group
}

// WithRuleUID adds the ruleUID to the get alert rules export params
func (o *GetAlertRulesExportParams) WithRuleUID(ruleUID *string) *GetAlertRulesExportParams {
	o.SetRuleUID(ruleUID)
	return o
}

// SetRuleUID adds the ruleUid to the get alert rules export params
func (o *GetAlertRulesExportParams) SetRuleUID(ruleUID *string) {
	o.RuleUID = ruleUID
}

// WriteToRequest writes these params to a swagger request
func (o *GetAlertRulesExportParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Download != nil {

		// query param download
		var qrDownload bool

		if o.Download != nil {
			qrDownload = *o.Download
		}
		qDownload := swag.FormatBool(qrDownload)
		if qDownload != "" {

			if err := r.SetQueryParam("download", qDownload); err != nil {
				return err
			}
		}
	}

	if o.FolderUID != nil {

		// binding items for folderUid
		joinedFolderUID := o.bindParamFolderUID(reg)

		// query array param folderUid
		if err := r.SetQueryParam("folderUid", joinedFolderUID...); err != nil {
			return err
		}
	}

	if o.Format != nil {

		// query param format
		var qrFormat string

		if o.Format != nil {
			qrFormat = *o.Format
		}
		qFormat := qrFormat
		if qFormat != "" {

			if err := r.SetQueryParam("format", qFormat); err != nil {
				return err
			}
		}
	}

	if o.Group != nil {

		// query param group
		var qrGroup string

		if o.Group != nil {
			qrGroup = *o.Group
		}
		qGroup := qrGroup
		if qGroup != "" {

			if err := r.SetQueryParam("group", qGroup); err != nil {
				return err
			}
		}
	}

	if o.RuleUID != nil {

		// query param ruleUid
		var qrRuleUID string

		if o.RuleUID != nil {
			qrRuleUID = *o.RuleUID
		}
		qRuleUID := qrRuleUID
		if qRuleUID != "" {

			if err := r.SetQueryParam("ruleUid", qRuleUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetAlertRulesExport binds the parameter folderUid
func (o *GetAlertRulesExportParams) bindParamFolderUID(formats strfmt.Registry) []string {
	folderUIDIR := o.FolderUID

	var folderUIDIC []string
	for _, folderUIDIIR := range folderUIDIR { // explode []string

		folderUIDIIV := folderUIDIIR // string as string
		folderUIDIC = append(folderUIDIC, folderUIDIIV)
	}

	// items.CollectionFormat: ""
	folderUIDIS := swag.JoinByFormat(folderUIDIC, "")

	return folderUIDIS
}
