// Code generated by go-swagger; DO NOT EDIT.

package datasource_permissions

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewAddPermissionParams creates a new AddPermissionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAddPermissionParams() *AddPermissionParams {
	return &AddPermissionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAddPermissionParamsWithTimeout creates a new AddPermissionParams object
// with the ability to set a timeout on a request.
func NewAddPermissionParamsWithTimeout(timeout time.Duration) *AddPermissionParams {
	return &AddPermissionParams{
		timeout: timeout,
	}
}

// NewAddPermissionParamsWithContext creates a new AddPermissionParams object
// with the ability to set a context for a request.
func NewAddPermissionParamsWithContext(ctx context.Context) *AddPermissionParams {
	return &AddPermissionParams{
		Context: ctx,
	}
}

// NewAddPermissionParamsWithHTTPClient creates a new AddPermissionParams object
// with the ability to set a custom HTTPClient for a request.
func NewAddPermissionParamsWithHTTPClient(client *http.Client) *AddPermissionParams {
	return &AddPermissionParams{
		HTTPClient: client,
	}
}

/*
AddPermissionParams contains all the parameters to send to the API endpoint

	for the add permission operation.

	Typically these are written to a http.Request.
*/
type AddPermissionParams struct {

	// BuiltinRole.
	BuiltinRole *string

	// DatasourceID.
	DatasourceID string

	// Permission.
	//
	// Format: int64
	Permission *int64

	// TeamID.
	//
	// Format: int64
	TeamID *int64

	// UserID.
	//
	// Format: int64
	UserID *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the add permission params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AddPermissionParams) WithDefaults() *AddPermissionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the add permission params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AddPermissionParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the add permission params
func (o *AddPermissionParams) WithTimeout(timeout time.Duration) *AddPermissionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the add permission params
func (o *AddPermissionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the add permission params
func (o *AddPermissionParams) WithContext(ctx context.Context) *AddPermissionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the add permission params
func (o *AddPermissionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the add permission params
func (o *AddPermissionParams) WithHTTPClient(client *http.Client) *AddPermissionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the add permission params
func (o *AddPermissionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBuiltinRole adds the builtinRole to the add permission params
func (o *AddPermissionParams) WithBuiltinRole(builtinRole *string) *AddPermissionParams {
	o.SetBuiltinRole(builtinRole)
	return o
}

// SetBuiltinRole adds the builtinRole to the add permission params
func (o *AddPermissionParams) SetBuiltinRole(builtinRole *string) {
	o.BuiltinRole = builtinRole
}

// WithDatasourceID adds the datasourceID to the add permission params
func (o *AddPermissionParams) WithDatasourceID(datasourceID string) *AddPermissionParams {
	o.SetDatasourceID(datasourceID)
	return o
}

// SetDatasourceID adds the datasourceId to the add permission params
func (o *AddPermissionParams) SetDatasourceID(datasourceID string) {
	o.DatasourceID = datasourceID
}

// WithPermission adds the permission to the add permission params
func (o *AddPermissionParams) WithPermission(permission *int64) *AddPermissionParams {
	o.SetPermission(permission)
	return o
}

// SetPermission adds the permission to the add permission params
func (o *AddPermissionParams) SetPermission(permission *int64) {
	o.Permission = permission
}

// WithTeamID adds the teamID to the add permission params
func (o *AddPermissionParams) WithTeamID(teamID *int64) *AddPermissionParams {
	o.SetTeamID(teamID)
	return o
}

// SetTeamID adds the teamId to the add permission params
func (o *AddPermissionParams) SetTeamID(teamID *int64) {
	o.TeamID = teamID
}

// WithUserID adds the userID to the add permission params
func (o *AddPermissionParams) WithUserID(userID *int64) *AddPermissionParams {
	o.SetUserID(userID)
	return o
}

// SetUserID adds the userId to the add permission params
func (o *AddPermissionParams) SetUserID(userID *int64) {
	o.UserID = userID
}

// WriteToRequest writes these params to a swagger request
func (o *AddPermissionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.BuiltinRole != nil {

		// query param builtinRole
		var qrBuiltinRole string

		if o.BuiltinRole != nil {
			qrBuiltinRole = *o.BuiltinRole
		}
		qBuiltinRole := qrBuiltinRole
		if qBuiltinRole != "" {

			if err := r.SetQueryParam("builtinRole", qBuiltinRole); err != nil {
				return err
			}
		}
	}

	// path param datasourceId
	if err := r.SetPathParam("datasourceId", o.DatasourceID); err != nil {
		return err
	}

	if o.Permission != nil {

		// query param permission
		var qrPermission int64

		if o.Permission != nil {
			qrPermission = *o.Permission
		}
		qPermission := swag.FormatInt64(qrPermission)
		if qPermission != "" {

			if err := r.SetQueryParam("permission", qPermission); err != nil {
				return err
			}
		}
	}

	if o.TeamID != nil {

		// query param teamId
		var qrTeamID int64

		if o.TeamID != nil {
			qrTeamID = *o.TeamID
		}
		qTeamID := swag.FormatInt64(qrTeamID)
		if qTeamID != "" {

			if err := r.SetQueryParam("teamId", qTeamID); err != nil {
				return err
			}
		}
	}

	if o.UserID != nil {

		// query param userId
		var qrUserID int64

		if o.UserID != nil {
			qrUserID = *o.UserID
		}
		qUserID := swag.FormatInt64(qrUserID)
		if qUserID != "" {

			if err := r.SetQueryParam("userId", qUserID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
