/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.tools.debugger.AbstractTreeTableModel;
import org.mozilla.javascript.tools.debugger.TreeTableModel;
import org.mozilla.javascript.tools.debugger.VariableNode;

public class VariableModel
extends AbstractTreeTableModel
implements TreeTableModel {
    protected static String[] cNames = new String[]{" Name", " Value"};
    protected static Class[] cTypes = new Class[]{class$org$mozilla$javascript$tools$debugger$TreeTableModel == null ? (class$org$mozilla$javascript$tools$debugger$TreeTableModel = VariableModel.class$("org.mozilla.javascript.tools.debugger.TreeTableModel")) : class$org$mozilla$javascript$tools$debugger$TreeTableModel, class$java$lang$String == null ? (class$java$lang$String = VariableModel.class$("java.lang.String")) : class$java$lang$String};
    static /* synthetic */ Class class$org$mozilla$javascript$tools$debugger$TreeTableModel;
    static /* synthetic */ Class class$java$lang$String;

    public VariableModel(Scriptable scope) {
        super(scope == null ? null : new VariableNode(scope, "this"));
    }

    protected Object getObject(Object node) {
        VariableNode varNode = (VariableNode)node;
        if (varNode == null) {
            return null;
        }
        return varNode.getObject();
    }

    protected Object[] getChildren(Object node) {
        VariableNode varNode = (VariableNode)node;
        return varNode.getChildren();
    }

    public int getChildCount(Object node) {
        Object[] children = this.getChildren(node);
        return children == null ? 0 : children.length;
    }

    public Object getChild(Object node, int i) {
        return this.getChildren(node)[i];
    }

    public boolean isLeaf(Object node) {
        if (node == null) {
            return true;
        }
        VariableNode varNode = (VariableNode)node;
        Object[] children = varNode.getChildren();
        return children == null || children.length <= 0;
    }

    public boolean isCellEditable(Object node, int column) {
        return column == 0;
    }

    public int getColumnCount() {
        return cNames.length;
    }

    public String getColumnName(int column) {
        return cNames[column];
    }

    public Class getColumnClass(int column) {
        return cTypes[column];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getValueAt(Object node, int column) {
        Context cx = Context.enter();
        try {
            try {
                Object value = this.getObject(node);
                switch (column) {
                    case 0: {
                        VariableNode varNode = (VariableNode)node;
                        String name = "";
                        if (varNode.name != null) {
                            String string = name + varNode.name;
                            Object var14_10 = null;
                            Context.exit();
                            return string;
                        }
                        String string = name + "[" + varNode.index + "]";
                        Object var14_11 = null;
                        Context.exit();
                        return string;
                    }
                    case 1: {
                        String result;
                        if (value == Undefined.instance || value == Scriptable.NOT_FOUND) {
                            String string = "undefined";
                            Object var14_12 = null;
                            Context.exit();
                            return string;
                        }
                        if (value == null) {
                            String string = "null";
                            Object var14_13 = null;
                            Context.exit();
                            return string;
                        }
                        if (value instanceof NativeCall) {
                            String string = "[object Call]";
                            Object var14_14 = null;
                            Context.exit();
                            return string;
                        }
                        try {
                            result = Context.toString(value);
                        }
                        catch (RuntimeException exc) {
                            result = exc.getMessage();
                        }
                        StringBuffer buf = new StringBuffer();
                        int len = result.length();
                        int i = 0;
                        while (true) {
                            if (i >= len) break;
                            char ch = result.charAt(i);
                            if (Character.isISOControl(ch)) {
                                ch = ' ';
                            }
                            buf.append(ch);
                            ++i;
                        }
                        String string = buf.toString();
                        Object var14_15 = null;
                        Context.exit();
                        return string;
                    }
                }
            }
            catch (Exception exc) {
                Object var14_17 = null;
                Context.exit();
                return null;
            }
            Object var14_16 = null;
            Context.exit();
            return null;
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            Context.exit();
            throw throwable;
        }
    }

    public void setScope(Scriptable scope) {
        VariableNode rootVar = (VariableNode)this.root;
        rootVar.scope = scope;
        this.fireTreeNodesChanged(this, new Object[]{this.root}, null, new Object[]{this.root});
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

