/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.Reader;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.ScriptRuntime;

public class TokenStream {
    static final int TSF_NEWLINES = 1;
    static final int TSF_FUNCTION = 2;
    static final int TSF_RETURN_EXPR = 4;
    static final int TSF_RETURN_VOID = 8;
    static final int TSF_REGEXP = 16;
    static final int TSF_DIRTYLINE = 32;
    private static final int EOF_CHAR = -1;
    int flags;
    String regExpFlags;
    private String sourceName;
    private String line;
    private boolean fromEval;
    private int pushbackToken;
    private int tokenno;
    private int op;
    private String string = "";
    private double number;
    private char[] stringBuffer = new char[128];
    private int stringBufferTop;
    private ObjToIntMap allStrings = new ObjToIntMap(50);
    private final int[] ungetBuffer = new int[3];
    private int ungetCursor;
    private boolean hitEOF = false;
    private static final int EOL_HINT_MASK = 57296;
    private int lineStart = 0;
    private int lineno;
    private int lineEndChar = -1;
    private String sourceString;
    private Reader sourceReader;
    private char[] sourceBuffer;
    private int sourceEnd;
    private int sourceCursor;
    CompilerEnvirons compilerEnv;

    public TokenStream(CompilerEnvirons compilerEnv, Reader sourceReader, String sourceString, String sourceName, int lineno) {
        this.compilerEnv = compilerEnv;
        this.pushbackToken = 0;
        this.sourceName = sourceName;
        this.lineno = lineno;
        this.flags = 0;
        if (sourceReader != null) {
            if (sourceString != null) {
                Kit.codeBug();
            }
            this.sourceReader = sourceReader;
            this.sourceBuffer = new char[512];
            this.sourceEnd = 0;
        } else {
            if (sourceString == null) {
                Kit.codeBug();
            }
            this.sourceString = sourceString;
            this.sourceEnd = sourceString.length();
        }
        this.sourceCursor = 0;
    }

    public String tokenToString(int token) {
        return "";
    }

    /*
     * Enabled aggressive block sorting
     */
    private int stringToKeyword(String name) {
        int Id_break = 98;
        int Id_case = 93;
        int Id_continue = 99;
        int Id_default = 94;
        int Id_delete = 32;
        int Id_do = 96;
        int Id_else = 91;
        int Id_export = 88;
        int Id_false = 46;
        int Id_for = 97;
        int Id_function = 87;
        int Id_if = 90;
        int Id_in = 54;
        int Id_new = 31;
        int Id_null = 44;
        int Id_return = 5;
        int Id_switch = 92;
        int Id_this = 45;
        int Id_true = 47;
        int Id_typeof = 33;
        int Id_var = 100;
        int Id_void = 104;
        int Id_while = 95;
        int Id_with = 101;
        int Id_abstract = 105;
        int Id_boolean = 105;
        int Id_byte = 105;
        int Id_catch = 102;
        int Id_char = 105;
        int Id_class = 105;
        int Id_const = 105;
        int Id_debugger = 105;
        int Id_double = 105;
        int Id_enum = 105;
        int Id_extends = 105;
        int Id_final = 105;
        int Id_finally = 103;
        int Id_float = 105;
        int Id_goto = 105;
        int Id_implements = 105;
        int Id_import = 89;
        int Id_instanceof = 55;
        int Id_int = 105;
        int Id_interface = 105;
        int Id_long = 105;
        int Id_native = 105;
        int Id_package = 105;
        int Id_private = 105;
        int Id_protected = 105;
        int Id_public = 105;
        int Id_short = 105;
        int Id_static = 105;
        int Id_super = 105;
        int Id_synchronized = 105;
        int Id_throw = 53;
        int Id_throws = 105;
        int Id_transient = 105;
        int Id_try = 69;
        int Id_volatile = 105;
        String s = name;
        int id = 0;
        String X = null;
        block0 : switch (s.length()) {
            case 2: {
                char c = s.charAt(1);
                if (c == 'f') {
                    if (s.charAt(0) != 'i') break;
                    return 90;
                }
                if (c == 'n') {
                    if (s.charAt(0) != 'i') break;
                    return 54;
                }
                if (c != 'o' || s.charAt(0) != 'd') break;
                return 96;
            }
            case 3: {
                switch (s.charAt(0)) {
                    case 'f': {
                        if (s.charAt(2) != 'r' || s.charAt(1) != 'o') break;
                        return 97;
                    }
                    case 'i': {
                        if (s.charAt(2) != 't' || s.charAt(1) != 'n') break;
                        return 105;
                    }
                    case 'n': {
                        if (s.charAt(2) != 'w' || s.charAt(1) != 'e') break;
                        return 31;
                    }
                    case 't': {
                        if (s.charAt(2) != 'y' || s.charAt(1) != 'r') break;
                        return 69;
                    }
                    case 'v': {
                        if (s.charAt(2) != 'r' || s.charAt(1) != 'a') break;
                        return 100;
                    }
                }
                break;
            }
            case 4: {
                switch (s.charAt(0)) {
                    case 'b': {
                        X = "byte";
                        id = 105;
                        break;
                    }
                    case 'c': {
                        char c = s.charAt(3);
                        if (c == 'e') {
                            if (s.charAt(2) != 's' || s.charAt(1) != 'a') break;
                            return 93;
                        }
                        if (c != 'r' || s.charAt(2) != 'a' || s.charAt(1) != 'h') break;
                        return 105;
                    }
                    case 'e': {
                        char c = s.charAt(3);
                        if (c == 'e') {
                            if (s.charAt(2) != 's' || s.charAt(1) != 'l') break;
                            return 91;
                        }
                        if (c != 'm' || s.charAt(2) != 'u' || s.charAt(1) != 'n') break;
                        return 105;
                    }
                    case 'g': {
                        X = "goto";
                        id = 105;
                        break;
                    }
                    case 'l': {
                        X = "long";
                        id = 105;
                        break;
                    }
                    case 'n': {
                        X = "null";
                        id = 44;
                        break;
                    }
                    case 't': {
                        char c = s.charAt(3);
                        if (c == 'e') {
                            if (s.charAt(2) != 'u' || s.charAt(1) != 'r') break;
                            return 47;
                        }
                        if (c != 's' || s.charAt(2) != 'i' || s.charAt(1) != 'h') break;
                        return 45;
                    }
                    case 'v': {
                        X = "void";
                        id = 104;
                        break;
                    }
                    case 'w': {
                        X = "with";
                        id = 101;
                        break;
                    }
                }
                break;
            }
            case 5: {
                switch (s.charAt(2)) {
                    case 'a': {
                        X = "class";
                        id = 105;
                        break;
                    }
                    case 'e': {
                        X = "break";
                        id = 98;
                        break;
                    }
                    case 'i': {
                        X = "while";
                        id = 95;
                        break;
                    }
                    case 'l': {
                        X = "false";
                        id = 46;
                        break;
                    }
                    case 'n': {
                        char c = s.charAt(0);
                        if (c == 'c') {
                            X = "const";
                            id = 105;
                            break;
                        }
                        if (c != 'f') break;
                        X = "final";
                        id = 105;
                        break;
                    }
                    case 'o': {
                        char c = s.charAt(0);
                        if (c == 'f') {
                            X = "float";
                            id = 105;
                            break;
                        }
                        if (c != 's') break;
                        X = "short";
                        id = 105;
                        break;
                    }
                    case 'p': {
                        X = "super";
                        id = 105;
                        break;
                    }
                    case 'r': {
                        X = "throw";
                        id = 53;
                        break;
                    }
                    case 't': {
                        X = "catch";
                        id = 102;
                        break;
                    }
                }
                break;
            }
            case 6: {
                switch (s.charAt(1)) {
                    case 'a': {
                        X = "native";
                        id = 105;
                        break;
                    }
                    case 'e': {
                        char c = s.charAt(0);
                        if (c == 'd') {
                            X = "delete";
                            id = 32;
                            break;
                        }
                        if (c != 'r') break;
                        X = "return";
                        id = 5;
                        break;
                    }
                    case 'h': {
                        X = "throws";
                        id = 105;
                        break;
                    }
                    case 'm': {
                        X = "import";
                        id = 89;
                        break;
                    }
                    case 'o': {
                        X = "double";
                        id = 105;
                        break;
                    }
                    case 't': {
                        X = "static";
                        id = 105;
                        break;
                    }
                    case 'u': {
                        X = "public";
                        id = 105;
                        break;
                    }
                    case 'w': {
                        X = "switch";
                        id = 92;
                        break;
                    }
                    case 'x': {
                        X = "export";
                        id = 88;
                        break;
                    }
                    case 'y': {
                        X = "typeof";
                        id = 33;
                        break;
                    }
                }
                break;
            }
            case 7: {
                switch (s.charAt(1)) {
                    case 'a': {
                        X = "package";
                        id = 105;
                        break block0;
                    }
                    case 'e': {
                        X = "default";
                        id = 94;
                        break block0;
                    }
                    case 'i': {
                        X = "finally";
                        id = 103;
                        break block0;
                    }
                    case 'o': {
                        X = "boolean";
                        id = 105;
                        break block0;
                    }
                    case 'r': {
                        X = "private";
                        id = 105;
                        break block0;
                    }
                    case 'x': {
                        X = "extends";
                        id = 105;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                switch (s.charAt(0)) {
                    case 'a': {
                        X = "abstract";
                        id = 105;
                        break block0;
                    }
                    case 'c': {
                        X = "continue";
                        id = 99;
                        break block0;
                    }
                    case 'd': {
                        X = "debugger";
                        id = 105;
                        break block0;
                    }
                    case 'f': {
                        X = "function";
                        id = 87;
                        break block0;
                    }
                    case 'v': {
                        X = "volatile";
                        id = 105;
                        break block0;
                    }
                }
                break;
            }
            case 9: {
                char c = s.charAt(0);
                if (c == 'i') {
                    X = "interface";
                    id = 105;
                    break;
                }
                if (c == 'p') {
                    X = "protected";
                    id = 105;
                    break;
                }
                if (c != 't') break;
                X = "transient";
                id = 105;
                break;
            }
            case 10: {
                char c = s.charAt(1);
                if (c == 'm') {
                    X = "implements";
                    id = 105;
                    break;
                }
                if (c != 'n') break;
                X = "instanceof";
                id = 55;
                break;
            }
            case 12: {
                X = "synchronized";
                id = 105;
            }
        }
        if (X != null && X != s && !X.equals(s)) {
            return 0;
        }
        if (id != 0) return id & 0xFF;
        return 0;
    }

    public final void reportCurrentLineError(String message) {
        this.compilerEnv.reportSyntaxError(message, this.getSourceName(), this.getLineno(), this.getLine(), this.getOffset());
    }

    public final void reportCurrentLineWarning(String message) {
        this.compilerEnv.reportSyntaxWarning(message, this.getSourceName(), this.getLineno(), this.getLine(), this.getOffset());
    }

    public final String getSourceName() {
        return this.sourceName;
    }

    public final int getLineno() {
        return this.lineno;
    }

    public final int getOp() {
        return this.op;
    }

    public final String getString() {
        return this.string;
    }

    public final double getNumber() {
        return this.number;
    }

    public final int getTokenno() {
        return this.tokenno;
    }

    public final boolean eof() {
        return this.hitEOF;
    }

    public final boolean matchToken(int toMatch) throws IOException {
        int token = this.getToken();
        if (token == toMatch) {
            return true;
        }
        --this.tokenno;
        this.pushbackToken = token;
        return false;
    }

    public final void ungetToken(int tt) {
        if (this.pushbackToken != 0 && tt != -1) {
            Kit.codeBug();
        }
        this.pushbackToken = tt;
        --this.tokenno;
    }

    public final int peekToken() throws IOException {
        int result;
        this.pushbackToken = result = this.getToken();
        --this.tokenno;
        return result;
    }

    public final int peekTokenSameLine() throws IOException {
        int result;
        this.flags |= 1;
        this.pushbackToken = result = this.getToken();
        --this.tokenno;
        this.flags &= 0xFFFFFFFE;
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public final int getToken() throws IOException {
        ++this.tokenno;
        if (this.pushbackToken != 0) {
            result = this.pushbackToken;
            this.pushbackToken = 0;
            if (result != 1 || (this.flags & 1) != 0) {
                return result;
            }
        }
        block38: while (true) {
            block129: {
                block130: {
                    if ((c = this.getChar()) == -1) {
                        return 0;
                    }
                    if (c == 10) {
                        this.flags &= -33;
                        if ((this.flags & 1) == 0) continue;
                        return 1;
                    }
                    if (TokenStream.isJSSpace(c)) continue;
                    if (c != 45) {
                        this.flags |= 32;
                    }
                    isUnicodeEscapeStart = false;
                    if (c == 92) {
                        c = this.getChar();
                        if (c == 117) {
                            identifierStart = true;
                            isUnicodeEscapeStart = true;
                            this.stringBufferTop = 0;
                        } else {
                            identifierStart = false;
                            this.ungetChar(c);
                            c = 92;
                        }
                    } else {
                        identifierStart = Character.isJavaIdentifierStart((char)c);
                        if (identifierStart) {
                            this.stringBufferTop = 0;
                            this.addToString(c);
                        }
                    }
                    if (identifierStart) {
                        containsEscape = isUnicodeEscapeStart;
                        while (true) {
                            if (isUnicodeEscapeStart) {
                                escapeVal = 0;
                                i = 0;
                                while (i != 4) {
                                    c = this.getChar();
                                    if ((escapeVal = escapeVal << 4 | TokenStream.xDigitToInt(c)) < 0) break;
                                    ++i;
                                }
                                if (escapeVal < 0) {
                                    this.reportCurrentLineError(Context.getMessage0("msg.invalid.escape"));
                                    return -1;
                                }
                                this.addToString(escapeVal);
                                isUnicodeEscapeStart = false;
                                continue;
                            }
                            c = this.getChar();
                            if (c == 92) {
                                c = this.getChar();
                                if (c == 117) {
                                    isUnicodeEscapeStart = true;
                                    containsEscape = true;
                                    continue;
                                }
                                this.reportCurrentLineError(Context.getMessage0("msg.illegal.character"));
                                return -1;
                            }
                            if (c == -1 || !Character.isJavaIdentifierPart((char)c)) break;
                            this.addToString(c);
                        }
                        this.ungetChar(c);
                        str = this.getStringFromBuffer();
                        if (!containsEscape && (result = this.stringToKeyword(str)) != 0) {
                            if (result != 105) {
                                return result;
                            }
                            if (!this.compilerEnv.reservedKeywordAsIdentifier) {
                                return result;
                            }
                            this.reportCurrentLineWarning(Context.getMessage1("msg.reserved.keyword", str));
                        }
                        this.string = (String)this.allStrings.intern(str);
                        return 39;
                    }
                    if (!TokenStream.isDigit(c) && (c != 46 || !TokenStream.isDigit(this.peekChar()))) break block129;
                    this.stringBufferTop = 0;
                    base = 10;
                    if (c == 48) {
                        c = this.getChar();
                        if (c == 120 || c == 88) {
                            base = 16;
                            c = this.getChar();
                        } else if (TokenStream.isDigit(c)) {
                            base = 8;
                        } else {
                            this.addToString(48);
                        }
                    }
                    if (base != 16) ** GOTO lbl96
                    while (0 <= TokenStream.xDigitToInt(c)) {
                        this.addToString(c);
                        c = this.getChar();
                    }
                    break block130;
lbl-1000:
                    // 1 sources

                    {
                        if (base == 8 && c >= 56) {
                            this.reportCurrentLineWarning(Context.getMessage1("msg.bad.octal.literal", c == 56 ? "8" : "9"));
                            base = 10;
                        }
                        this.addToString(c);
                        c = this.getChar();
lbl96:
                        // 2 sources

                        ** while (48 <= c && c <= 57)
                    }
                }
                isInteger = true;
                if (base == 10 && (c == 46 || c == 101 || c == 69)) {
                    isInteger = false;
                    if (c == 46) {
                        do {
                            this.addToString(c);
                        } while (TokenStream.isDigit(c = this.getChar()));
                    }
                    if (c == 101 || c == 69) {
                        this.addToString(c);
                        c = this.getChar();
                        if (c == 43 || c == 45) {
                            this.addToString(c);
                            c = this.getChar();
                        }
                        if (!TokenStream.isDigit(c)) {
                            this.reportCurrentLineError(Context.getMessage0("msg.missing.exponent"));
                            return -1;
                        }
                        do {
                            this.addToString(c);
                        } while (TokenStream.isDigit(c = this.getChar()));
                    }
                }
                this.ungetChar(c);
                numString = this.getStringFromBuffer();
                if (base == 10 && !isInteger) {
                    try {
                        dval = Double.valueOf(numString);
                    }
                    catch (NumberFormatException ex) {
                        this.reportCurrentLineError(Context.getMessage1("msg.caught.nfe", ex.getMessage()));
                        return -1;
                    }
                } else {
                    dval = ScriptRuntime.stringToNumber(numString, 0, base);
                }
                this.number = dval;
                return 40;
            }
            if (c == 34 || c == 39) {
                quoteChar = c;
                this.stringBufferTop = 0;
                c = this.getChar();
                block45: while (c != quoteChar) {
                    if (c == 10 || c == -1) {
                        this.ungetChar(c);
                        this.reportCurrentLineError(Context.getMessage0("msg.unterminated.string.lit"));
                        return -1;
                    }
                    if (c == 92) {
                        c = this.getChar();
                        switch (c) {
                            case 98: {
                                c = 8;
                                break;
                            }
                            case 102: {
                                c = 12;
                                break;
                            }
                            case 110: {
                                c = 10;
                                break;
                            }
                            case 114: {
                                c = 13;
                                break;
                            }
                            case 116: {
                                c = 9;
                                break;
                            }
                            case 118: {
                                c = 11;
                                break;
                            }
                            case 117: {
                                escapeStart = this.stringBufferTop;
                                this.addToString(117);
                                escapeVal = 0;
                                i = 0;
                                while (i != 4) {
                                    c = this.getChar();
                                    if ((escapeVal = escapeVal << 4 | TokenStream.xDigitToInt(c)) < 0) continue block45;
                                    this.addToString(c);
                                    ++i;
                                }
                                this.stringBufferTop = escapeStart;
                                c = escapeVal;
                                break;
                            }
                            case 120: {
                                c = this.getChar();
                                escapeVal = TokenStream.xDigitToInt(c);
                                if (escapeVal < 0) {
                                    this.addToString(120);
                                    continue block45;
                                }
                                c1 = c;
                                c = this.getChar();
                                if ((escapeVal = escapeVal << 4 | TokenStream.xDigitToInt(c)) < 0) {
                                    this.addToString(120);
                                    this.addToString(c1);
                                    continue block45;
                                }
                                c = escapeVal;
                                break;
                            }
                            default: {
                                if (48 > c || c >= 56) break;
                                val = c - 48;
                                c = this.getChar();
                                if (48 <= c && c < 56) {
                                    val = 8 * val + c - 48;
                                    c = this.getChar();
                                    if (48 <= c && c < 56 && val <= 31) {
                                        val = 8 * val + c - 48;
                                        c = this.getChar();
                                    }
                                }
                                this.ungetChar(c);
                                c = val;
                            }
                        }
                    }
                    this.addToString(c);
                    c = this.getChar();
                }
                str = this.getStringFromBuffer();
                this.string = (String)this.allStrings.intern(str);
                return 41;
            }
            switch (c) {
                case 59: {
                    return 70;
                }
                case 91: {
                    return 71;
                }
                case 93: {
                    return 72;
                }
                case 123: {
                    return 73;
                }
                case 125: {
                    return 74;
                }
                case 40: {
                    return 75;
                }
                case 41: {
                    return 76;
                }
                case 44: {
                    return 77;
                }
                case 63: {
                    return 80;
                }
                case 58: {
                    return 81;
                }
                case 46: {
                    return 86;
                }
                case 124: {
                    if (this.matchChar(124)) {
                        return 82;
                    }
                    if (this.matchChar(61)) {
                        this.op = 10;
                        return 79;
                    }
                    return 10;
                }
                case 94: {
                    if (this.matchChar(61)) {
                        this.op = 11;
                        return 79;
                    }
                    return 11;
                }
                case 38: {
                    if (this.matchChar(38)) {
                        return 83;
                    }
                    if (this.matchChar(61)) {
                        this.op = 12;
                        return 79;
                    }
                    return 12;
                }
                case 61: {
                    if (this.matchChar(61)) {
                        if (this.matchChar(61)) {
                            return 48;
                        }
                        return 13;
                    }
                    return 78;
                }
                case 33: {
                    if (this.matchChar(61)) {
                        if (this.matchChar(61)) {
                            return 49;
                        }
                        return 14;
                    }
                    return 27;
                }
                case 60: {
                    if (this.matchChar(33)) {
                        if (this.matchChar(45)) {
                            if (this.matchChar(45)) {
                                this.skipLine();
                                continue block38;
                            }
                            this.ungetChar(45);
                        }
                        this.ungetChar(33);
                    }
                    if (this.matchChar(60)) {
                        if (this.matchChar(61)) {
                            this.op = 19;
                            return 79;
                        }
                        return 19;
                    }
                    if (this.matchChar(61)) {
                        return 16;
                    }
                    return 15;
                }
                case 62: {
                    if (this.matchChar(62)) {
                        if (this.matchChar(62)) {
                            if (this.matchChar(61)) {
                                this.op = 21;
                                return 79;
                            }
                            return 21;
                        }
                        if (this.matchChar(61)) {
                            this.op = 20;
                            return 79;
                        }
                        return 20;
                    }
                    if (this.matchChar(61)) {
                        return 18;
                    }
                    return 17;
                }
                case 42: {
                    if (this.matchChar(61)) {
                        this.op = 24;
                        return 79;
                    }
                    return 24;
                }
                case 47: {
                    if (this.matchChar(47)) {
                        this.skipLine();
                        continue block38;
                    }
                    if (this.matchChar(42)) {
                        lookForSlash = false;
                        while (true) {
                            if ((c = this.getChar()) == -1) {
                                this.reportCurrentLineError(Context.getMessage0("msg.unterminated.comment"));
                                return -1;
                            }
                            if (c == 42) {
                                lookForSlash = true;
                                continue;
                            }
                            if (c == 47) {
                                if (!lookForSlash) continue;
                                continue block38;
                            }
                            lookForSlash = false;
                        }
                    }
                    if ((this.flags & 16) != 0) {
                        this.stringBufferTop = 0;
                        while ((c = this.getChar()) != 47) {
                            if (c == 10 || c == -1) {
                                this.ungetChar(c);
                                this.reportCurrentLineError(Context.getMessage0("msg.unterminated.re.lit"));
                                return -1;
                            }
                            if (c == 92) {
                                this.addToString(c);
                                c = this.getChar();
                            }
                            this.addToString(c);
                        }
                        reEnd = this.stringBufferTop;
                        while (true) {
                            if (this.matchChar(103)) {
                                this.addToString(103);
                                continue;
                            }
                            if (this.matchChar(105)) {
                                this.addToString(105);
                                continue;
                            }
                            if (!this.matchChar(109)) break;
                            this.addToString(109);
                        }
                        if (TokenStream.isAlpha(this.peekChar())) {
                            this.reportCurrentLineError(Context.getMessage0("msg.invalid.re.flag"));
                            return -1;
                        }
                        this.string = new String(this.stringBuffer, 0, reEnd);
                        this.regExpFlags = new String(this.stringBuffer, reEnd, this.stringBufferTop - reEnd);
                        return 50;
                    }
                    if (this.matchChar(61)) {
                        this.op = 25;
                        return 79;
                    }
                    return 25;
                }
                case 37: {
                    if (this.matchChar(61)) {
                        this.op = 26;
                        return 79;
                    }
                    return 26;
                }
                case 126: {
                    return 28;
                }
                case 43: {
                    if (this.matchChar(61)) {
                        this.op = 22;
                        return 79;
                    }
                    if (this.matchChar(43)) {
                        return 84;
                    }
                    return 22;
                }
                case 45: {
                    if (this.matchChar(61)) {
                        this.op = 23;
                        c = 79;
                    } else if (this.matchChar(45)) {
                        if (0 == (this.flags & 32) && this.matchChar(62)) {
                            this.skipLine();
                            continue block38;
                        }
                        c = 85;
                    } else {
                        c = 23;
                    }
                    this.flags |= 32;
                    return c;
                }
            }
            break;
        }
        this.reportCurrentLineError(Context.getMessage0("msg.illegal.character"));
        return -1;
    }

    private static boolean isAlpha(int c) {
        if (c <= 90) {
            return 65 <= c;
        }
        return 97 <= c && c <= 122;
    }

    static boolean isDigit(int c) {
        return 48 <= c && c <= 57;
    }

    static int xDigitToInt(int c) {
        if (c <= 57) {
            if (0 <= (c -= 48)) {
                return c;
            }
        } else if (c <= 70) {
            if (65 <= c) {
                return c - 55;
            }
        } else if (c <= 102 && 97 <= c) {
            return c - 87;
        }
        return -1;
    }

    public static boolean isJSSpace(int c) {
        if (c <= 127) {
            return c == 32 || c == 9 || c == 12 || c == 11;
        }
        return c == 160 || Character.getType((char)c) == 12;
    }

    public static boolean isJSLineTerminator(int c) {
        return c == 10 || c == 13 || c == 8232 || c == 8233;
    }

    private static boolean isJSFormatChar(int c) {
        return c > 127 && Character.getType((char)c) == 16;
    }

    private String getStringFromBuffer() {
        return new String(this.stringBuffer, 0, this.stringBufferTop);
    }

    private void addToString(int c) {
        int N = this.stringBufferTop;
        if (N == this.stringBuffer.length) {
            char[] tmp = new char[this.stringBuffer.length * 2];
            System.arraycopy(this.stringBuffer, 0, tmp, 0, N);
            this.stringBuffer = tmp;
        }
        this.stringBuffer[N] = (char)c;
        this.stringBufferTop = N + 1;
    }

    private void ungetChar(int c) {
        if (this.ungetCursor != 0 && this.ungetBuffer[this.ungetCursor - 1] == 10) {
            Kit.codeBug();
        }
        this.ungetBuffer[this.ungetCursor++] = c;
    }

    private boolean matchChar(int test) throws IOException {
        int c = this.getChar();
        if (c == test) {
            return true;
        }
        this.ungetChar(c);
        return false;
    }

    private int peekChar() throws IOException {
        int c = this.getChar();
        this.ungetChar(c);
        return c;
    }

    private int getChar() throws IOException {
        int c;
        block11: {
            if (this.ungetCursor != 0) {
                return this.ungetBuffer[--this.ungetCursor];
            }
            while (true) {
                if (this.sourceString != null) {
                    if (this.sourceCursor == this.sourceEnd) {
                        this.hitEOF = true;
                        return -1;
                    }
                    c = this.sourceString.charAt(this.sourceCursor++);
                } else {
                    if (this.sourceCursor == this.sourceEnd && !this.fillSourceBuffer()) {
                        this.hitEOF = true;
                        return -1;
                    }
                    c = this.sourceBuffer[this.sourceCursor++];
                }
                if (this.lineEndChar >= 0) {
                    if (this.lineEndChar == 13 && c == 10) {
                        this.lineEndChar = 10;
                        continue;
                    }
                    this.lineEndChar = -1;
                    this.lineStart = this.sourceCursor - 1;
                    ++this.lineno;
                }
                if (c <= 127) {
                    if (c == 10 || c == 13) {
                        this.lineEndChar = c;
                        c = 10;
                    }
                    break block11;
                }
                if (!TokenStream.isJSFormatChar(c)) break;
            }
            if ((c & 0xDFD0) == 0 && TokenStream.isJSLineTerminator(c)) {
                this.lineEndChar = c;
                c = 10;
            }
        }
        return c;
    }

    private void skipLine() throws IOException {
        int c;
        while ((c = this.getChar()) != -1 && c != 10) {
        }
        this.ungetChar(c);
    }

    public final int getOffset() {
        int n = this.sourceCursor - this.lineStart;
        if (this.lineEndChar >= 0) {
            --n;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public final String getLine() {
        block8: {
            block9: {
                if (this.sourceString == null) break block8;
                lineEnd = this.sourceCursor;
                if (this.lineEndChar < 0) ** GOTO lbl8
                --lineEnd;
                break block9;
                while (((c = this.sourceString.charAt(lineEnd)) & 57296) != 0 || !TokenStream.isJSLineTerminator(c)) {
                    ++lineEnd;
lbl8:
                    // 2 sources

                    if (lineEnd != this.sourceEnd) continue;
                }
            }
            return this.sourceString.substring(this.lineStart, lineEnd);
        }
        lineLength = this.sourceCursor - this.lineStart;
        if (this.lineEndChar >= 0) {
            --lineLength;
        } else {
            while (true) {
                if ((i = this.lineStart + lineLength) == this.sourceEnd) {
                    try {
                        if (!this.fillSourceBuffer()) {
                        }
                    }
                    catch (IOException ioe) {}
                    break;
                    i = this.lineStart + lineLength;
                }
                if (((c = this.sourceBuffer[i]) & 57296) == 0 && TokenStream.isJSLineTerminator(c)) break;
                ++lineLength;
            }
        }
        return new String(this.sourceBuffer, this.lineStart, lineLength);
    }

    private boolean fillSourceBuffer() throws IOException {
        int n;
        if (this.sourceString != null) {
            Kit.codeBug();
        }
        if (this.sourceEnd == this.sourceBuffer.length) {
            if (this.lineStart != 0) {
                System.arraycopy(this.sourceBuffer, this.lineStart, this.sourceBuffer, 0, this.sourceEnd - this.lineStart);
                this.sourceEnd -= this.lineStart;
                this.sourceCursor -= this.lineStart;
                this.lineStart = 0;
            } else {
                char[] tmp = new char[this.sourceBuffer.length * 2];
                System.arraycopy(this.sourceBuffer, 0, tmp, 0, this.sourceEnd);
                this.sourceBuffer = tmp;
            }
        }
        if ((n = this.sourceReader.read(this.sourceBuffer, this.sourceEnd, this.sourceBuffer.length - this.sourceEnd)) < 0) {
            return false;
        }
        this.sourceEnd += n;
        return true;
    }
}

